package ru.yandex.msearch.proxy.api;

import ru.yandex.msearch.proxy.HttpServer;
import ru.yandex.msearch.proxy.MsearchProxyException;

public abstract class AbstractDispatchableService
    implements DispatchableService
{
    private final String[] mandatorySearchParams;

    public AbstractDispatchableService(final String[] mandatorySearchParams) {
        this.mandatorySearchParams = mandatorySearchParams;
    }

    @Override
    public boolean allowIndex() {
        return false;
    }

    @Override
    public boolean allowModify() {
        return false;
    }

    @Override
    public boolean allowUpdate() {
        return false;
    }

    @Override
    public boolean allowDelete() {
        return false;
    }

    @Override
    public boolean allowSearch() {
        return false;
    }

    @Override
    public boolean wait(final String api, final HttpServer.HttpParams params) {
        return params.getBoolean("wait", false);
    }

    @Override
    public void checkSearchParams(final HttpServer.HttpParams params)
        throws MsearchProxyException
    {
        for (String param: mandatorySearchParams) {
            if (params.get(param) == null) {
                throw new BadRequestException("Missing parameter: " + param);
            }
        }
    }

    @Override
    public int process(
        final ServiceProcessor processor,
        final HttpServer.HttpParams params)
        throws MsearchProxyException
    {
        int dispatchResult = processor.dispatch(params);
        if (dispatchResult == -1) {
            dispatchResult = processInternal(processor, params);
        }
        if (dispatchResult == -1) {
            dispatchResult = processor.unknownApi();
        }
        return dispatchResult;
    }

    protected int processInternal(
        final ServiceProcessor processor,
        final HttpServer.HttpParams params)
        throws MsearchProxyException
    {
        return -1;
    }
}

