package ru.yandex.msearch.proxy.api;

import java.io.PrintStream;

import ru.yandex.msearch.proxy.HttpServer;
import ru.yandex.msearch.proxy.MsearchProxyException;
import ru.yandex.msearch.proxy.Synonyms;
import ru.yandex.msearch.proxy.api.mail.Mail;
import ru.yandex.msearch.proxy.api.poeskupdate.PoeskUpdate;
import ru.yandex.msearch.proxy.api.postmaster.PostMaster;
import ru.yandex.msearch.proxy.api.suggest.Suggest;
import ru.yandex.msearch.proxy.config.ImmutableMsearchProxyConfig;
import ru.yandex.msearch.proxy.dispatcher.DispatcherException;
import ru.yandex.msearch.proxy.logger.Logger;

import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;

public class Api {
    private final Synonyms synonyms = new Synonyms();
    private final Suggest suggest;

    public Api(
        final IniConfig config,
        final ImmutableMsearchProxyConfig proxyConfig)
        throws Exception
    {
        suggest = new Suggest(synonyms, config.section("suggest"), proxyConfig);
        Chemodan.init(proxyConfig);
        Mail.init(config.section("mail"), proxyConfig);
        PostMaster.init(config.section("postmaster"));
    }

    public Synonyms synonyms() {
        return synonyms;
    }

    public Suggest suggest() {
        return suggest;
    }

    public int dispatch( HttpServer.RequestContext ctx, String request, String requestType, HttpServer.HttpParams params, HttpServer.HttpHeaders headers, PrintStream ps ) throws MsearchProxyException, ApiException
    {
	if( request.startsWith("/api/mail") )
	{
	    return new Mail( ctx, request, requestType, params, headers, ps ).dispatch();
	}
	else if( request.startsWith("/api/chemodan/search") || request.startsWith("/api/chemodan_search") )
	{
            return Chemodan.search( ctx, request, requestType, params, ps  );
	}
	else if( request.startsWith("/api/chemodan/info") || request.startsWith("/api/chemodan_info") )
	{
            return Chemodan.info( ctx, params, ps );
	}
	else if( request.startsWith("/api/search-update") )
	{
	    return PoeskUpdate.process( ctx, request, params, ps );
	}
	else if( request.startsWith("/api/postmaster/" ) )
	{
            PostMaster postmaster = new PostMaster();
            return postmaster.process( new ServiceProcessor( postmaster, ctx, request ), params );
	}
        else if( request.startsWith("/api/suggest/" ) )
        {
            try
            {
                return suggest.search( ctx, request, requestType, params, headers, ps  );
            }
            catch( Exception e )
            {
                return dispatchError( ctx, ps, "Suggest", e, 500 );
            }
        }
        ctx.setHttpCode( 500 );
        ps.println( "Unknown api method" );
        ctx.log.err( "Unknown api method: " + request );
        return 0;
    }

    private int dispatchError(
        final HttpServer.RequestContext ctx,
        final PrintStream ps,
        final String service,
        final Exception e,
        final int status)
    {
        ctx.log.err( service + ".dispatch error: " + e.getMessage() );
        ctx.log.err( Logger.exception(e) );
        ctx.setHttpCode( status );
        ps.println( service + ".dispatch: " + e.getMessage() );
        ps.println( Logger.exception(e) );
        return 0;
    }
}
