package ru.yandex.msearch.proxy.api;

import org.apache.http.HttpStatus;
import ru.yandex.msearch.proxy.MsearchProxyException;

public class ApiException extends MsearchProxyException {
    private int statusCode;
    public ApiException(String msg) {
	super(msg);
	statusCode = HttpStatus.SC_INTERNAL_SERVER_ERROR;
    }

    public ApiException(final String msg, final int statusCode) {
	super(msg);
	this.statusCode = statusCode;
    }

    public ApiException(final String msg, final Exception e) {
        this(msg, e, HttpStatus.SC_INTERNAL_SERVER_ERROR);
    }

    public ApiException(final String msg, final Exception e,
        final int statusCode)
    {
	super(msg, e);
	this.statusCode = statusCode;
    }

    public ApiException(Exception e, final int statusCode) {
	super(e);
	this.statusCode = statusCode;;
    }

    public ApiException(Exception e) {
	super(e);
	statusCode = HttpStatus.SC_INTERNAL_SERVER_ERROR;
    }

    public int statusCode() {
        return statusCode;
    }
}
