package ru.yandex.msearch.proxy.api;

import org.apache.http.HttpStatus;
import ru.yandex.msearch.proxy.MsearchProxyException;

public class BadRequestException extends ApiException {
    public BadRequestException(final String msg) {
	super("Bad request: " + msg, HttpStatus.SC_BAD_REQUEST);
    }

    public BadRequestException(final Exception e) {
	this("Bad request: " + e.getMessage(), e);
    }

    public BadRequestException(final String msg, final Exception e) {
	super(msg, e, HttpStatus.SC_BAD_REQUEST);
    }
}
