package ru.yandex.msearch.proxy.api;

import java.io.PrintStream;

import ru.yandex.msearch.proxy.HttpServer;
import ru.yandex.msearch.proxy.HttpServer.HttpParams;
import ru.yandex.msearch.proxy.MsearchProxyException;
import ru.yandex.msearch.proxy.api.async.ProxyParams;
import ru.yandex.msearch.proxy.api.chemodan.Attr;
import ru.yandex.msearch.proxy.api.chemodan.ChemodanCollector;
import ru.yandex.msearch.proxy.api.chemodan.ChemodanMailSearcher;
import ru.yandex.msearch.proxy.api.chemodan.ChemodanPrinter;
import ru.yandex.msearch.proxy.api.chemodan.ChemodanSearcher;
import ru.yandex.msearch.proxy.api.chemodan.SortingCollector;
import ru.yandex.msearch.proxy.api.chemodan.UserInfo;
import ru.yandex.msearch.proxy.config.ImmutableMsearchProxyConfig;
import ru.yandex.parser.config.ConfigException;

public class Chemodan
{
    public static void init(
        final ImmutableMsearchProxyConfig proxyConfig)
        throws ConfigException
    {
        ChemodanMailSearcher.init(proxyConfig);
        UserInfo.init(proxyConfig);
    }

    public static int search( HttpServer.RequestContext ctx, String request, String requestType, HttpParams params, PrintStream ps )
        throws ApiException, MsearchProxyException
    {

	String requestStr = params.get(ProxyParams.REQUEST);
	if( requestStr == null ) requestStr = "";
	String sort = params.get("sort");
	String order = params.get("order");
	String treeStr = params.get("tree");
	String path = params.get("path");
	String uid = params.getSafe(ProxyParams.UID);
	String service = params.get("service");

	int offset = 0;
	int length = 9999999;

	if( params.get("offset") != null ) offset = Integer.parseInt( params.get("offset") );
	if( params.get("amt") != null ) length = Integer.parseInt( params.get("amt") );

	if( uid != null && uid.isEmpty() )
	{
	    throw new ApiException( "missing parameter uid" );
	}
	
	if( path == null ) path = "";

	boolean tree = true;
	if( treeStr == null ) tree = true;
	else if( treeStr.isEmpty() || treeStr.equalsIgnoreCase("no") || treeStr.equals("0") ) tree = false;
	
	boolean desc = false;
	if( order != null && order.equalsIgnoreCase("desc") ) desc = true;
	if( sort == null || (sort != null && sort.isEmpty()) )
	{
	    if( requestStr.isEmpty() ) sort = Attr.NAME.diskName();
	    else
	    {
		sort = Attr.CTIME.diskName();
		desc = true;
	    }
	}

	if( params.get("newstyle") == null && !requestStr.isEmpty() )
	{
	    tree = false;
	}

        int toFind = 9999999;
        if (!"true".equals(params.get("precise-resources-count"))) {
            toFind = offset + length + 1;
        }

        Attr sortAttr = Attr.resolveDiskName(sort);
        if (sortAttr == null) {
            throw new ApiException("Unknown sort field: " + sort);
        }

	ChemodanCollector collector =
            new SortingCollector(sortAttr, !desc, offset + length);
	ChemodanSearcher searcher = new ChemodanMailSearcher(
            ctx,
            params,
            new UserInfo(ctx, uid),
            offset,
            length,
            sortAttr,
            desc);
	searcher.search( collector, path, tree, requestStr, toFind );

	ChemodanPrinter printer = new ChemodanPrinter( ctx );
	printer.print( collector, ps, offset, length );
	return collector.getCount();
//	return 0;
    }

    public static int info( HttpServer.RequestContext ctx, HttpParams params, PrintStream ps )
        throws ApiException, MsearchProxyException
    {
	String path = params.get("path");
	String uid = params.get(ProxyParams.UID);
	String service = params.get("service");

	if( path == null ) path = params.get("id");
	if( path == null ) path = "";
	if( uid == null || (uid != null && uid.isEmpty() ) )
	{
	    throw new ApiException( "missing parameter uid" );
	}

	ChemodanCollector collector =
            new SortingCollector(Attr.NAME, true, 100);
	ChemodanSearcher searcher = new ChemodanMailSearcher(
            ctx,
            params,
            new UserInfo(ctx, uid),
            -1,
            -1,
            Attr.NAME,
            false);
	searcher.info( collector, path );
	ChemodanPrinter printer = new ChemodanPrinter( ctx );
	printer.print( collector, ps, 0, 9999999 );
	return collector.getCount();
    }
}

