package ru.yandex.msearch.proxy.api;

import ru.yandex.msearch.proxy.HttpServer;
import ru.yandex.msearch.proxy.MsearchProxyException;

import ru.yandex.search.prefix.PrefixParser;

public interface DispatchableService {
    // service name as it written in uri, like /api/<name>/index
    String name();
    // service name as it written in searchmap
    String serviceName() throws MsearchProxyException;
    PrefixParser prefixParser();
    int indexTimeout();
    int searchTimeout();
    boolean allowIndex();
    boolean allowModify();
    boolean allowUpdate();
    boolean allowDelete();
    boolean allowSearch();
    boolean wait(String api, HttpServer.HttpParams params);
    void checkSearchParams(HttpServer.HttpParams params)
        throws MsearchProxyException;
    int process(ServiceProcessor processor, HttpServer.HttpParams params)
        throws MsearchProxyException;
}

