package ru.yandex.msearch.proxy.api.async;

import java.util.List;

import org.apache.http.HttpException;
import org.apache.http.HttpHost;
import org.apache.http.nio.protocol.HttpAsyncExchange;
import org.apache.http.protocol.HttpContext;

import ru.yandex.http.proxy.BasicProxySession;
import ru.yandex.http.util.nio.client.RequestsListener;
import ru.yandex.msearch.proxy.AsyncHttpServer;
import ru.yandex.parser.searchmap.User;

public class BasicSession
    extends BasicProxySession
    implements Session
{
    private final AsyncHttpServer server;

    public BasicSession(
        final AsyncHttpServer server,
        final HttpAsyncExchange exchange,
        final HttpContext context)
        throws HttpException
    {
        super(server, exchange, context);
        this.server = server;
    }

    @Override
    public AsyncHttpServer server() {
        return server;
    }

    @Override
    public List<HttpHost> searchHosts(final User user) {
        return server.searchMap().searchHosts(user);
    }

    @Override
    public RequestsListener requestsListener() {
        return listener();
    }

    @Override
    public void setSessionInfo(final String name, final String value) {
        connection().setSessionInfo(name, value);
    }

    @Override
    public void handleException(final Exception e) {
        exchange().submitResponse(server.handleException(e, context()));
    }
}

