package ru.yandex.msearch.proxy.api.async;

public class SubrequestsCounter {
    private int subrequests = 0;
    private boolean allSubrequestsSent = false;
    private final Runnable callback;

    public SubrequestsCounter() {
        this((Runnable) null);
    }

    public SubrequestsCounter(final Runnable callback) {
        this.callback = callback;
    }

    public synchronized boolean sent(final int sent) {
        subrequests += sent;
        allSubrequestsSent = true;
        return checkCompletion();
    }

    public synchronized boolean received() {
        subrequests -= 1;
        return checkCompletion();
    }

    private synchronized boolean checkCompletion() {
        if (subrequests == 0 && allSubrequestsSent) {
            allSubrequestsSent = false;
            if (callback != null) {
                callback.run();
            }
            return true;
        }
        return false;
    }
}
