package ru.yandex.msearch.proxy.api.async.broadcast;

import java.util.Collections;
import java.util.List;
import java.util.Map.Entry;

import org.apache.http.HttpException;
import org.apache.http.HttpHost;

import ru.yandex.parser.uri.CgiParams;

import ru.yandex.search.rules.RequestParams;
import ru.yandex.search.rules.SearchInfo;
import ru.yandex.search.rules.SearchRequest;
import ru.yandex.search.rules.SearchRule;

public class ReplaceUserRule
    implements
    SearchRule<List<Entry<HttpHost, String>>, RequestParams, SearchInfo>
{
    private final SearchRule<List<Entry<HttpHost, String>>, RequestParams,
        SearchInfo> next;

    public ReplaceUserRule(
        final SearchRule<List<Entry<HttpHost, String>>, RequestParams,
            SearchInfo> next)
    {
        this.next = next;
    }

    @Override
    public void execute(
        final SearchRequest<List<Entry<HttpHost, String>>, RequestParams,
            SearchInfo> request)
        throws HttpException
    {
        CgiParams params = request.cgiParams();
        Long kps = params.getLong("kps", null);
        if (kps != null) {
            params.putIfAbsent(
                "suid",
                Collections.singletonList(kps.toString()));
        }

        String db = params.getString("db", null);
        if (db != null) {
            params.putIfAbsent("mdb", Collections.singletonList(db));
        }

        next.execute(request);
    }
}
