package ru.yandex.msearch.proxy.api.async.broadcast;

import java.util.List;
import java.util.Map;

import org.apache.http.HttpException;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;

import org.apache.http.nio.protocol.BasicAsyncRequestConsumer;
import org.apache.http.nio.protocol.HttpAsyncExchange;
import org.apache.http.nio.protocol.HttpAsyncRequestHandler;

import org.apache.http.protocol.HttpContext;

import ru.yandex.http.proxy.BasicProxySession;
import ru.yandex.http.proxy.ProxySession;

import ru.yandex.msearch.proxy.AsyncHttpServer;

import ru.yandex.search.rules.BasicSearchRequest;
import ru.yandex.search.rules.RequestParams;
import ru.yandex.search.rules.ResolveUserRule;
import ru.yandex.search.rules.SearchInfo;
import ru.yandex.search.rules.SearchRequest;
import ru.yandex.search.rules.SearchRule;

public class SelfBroadcastHandler
    implements HttpAsyncRequestHandler<HttpRequest>
{
    private final AsyncHttpServer server;
    private final SearchRule<List<Map.Entry<HttpHost, String>>,
        RequestParams, SearchInfo> rule;

    public SelfBroadcastHandler(final AsyncHttpServer server) {
        this.server = server;

        SearchRule<List<Map.Entry<HttpHost, String>>, RequestParams,
            SearchInfo> rule = new BroadcastRule(
            server);
        rule = new ResolveUserRule<>(rule, server::blackboxClient);
        this.rule = new ReplaceUserRule(rule);
    }

    @Override
    public BasicAsyncRequestConsumer processRequest(
        final HttpRequest request,
        final HttpContext context)
    {
        return new BasicAsyncRequestConsumer();
    }

    @Override
    public void handle(
        final HttpRequest request,
        final HttpAsyncExchange exchange,
        final HttpContext context)
        throws HttpException
    {
        ProxySession session = new BasicProxySession(server, exchange, context);

        SearchRequest<List<Map.Entry<HttpHost, String>>, RequestParams,
            SearchInfo> searchRequest =
            new BasicSearchRequest<>(session, new SelfBroadcastService());
        rule.execute(searchRequest);
    }

    @Override
    public String toString() {
        return "Return responses from route for each index backend";
    }
}
