package ru.yandex.msearch.proxy.api.async.broadcast;

import java.io.IOException;
import java.io.OutputStreamWriter;

import java.nio.charset.CharsetEncoder;
import java.nio.charset.CodingErrorAction;

import java.util.List;
import java.util.Map;

import org.apache.http.HttpHost;
import org.apache.http.HttpStatus;

import org.apache.http.entity.ContentType;

import org.apache.http.nio.entity.NByteArrayEntity;

import ru.yandex.http.proxy.AbstractProxySessionCallback;
import ru.yandex.http.proxy.ProxySession;

import ru.yandex.http.util.nio.NByteArrayEntityFactory;

import ru.yandex.io.DecodableByteArrayOutputStream;

public class SelfBroadcastPrinter
    extends AbstractProxySessionCallback<List<Map.Entry<HttpHost, String>>>
{
    public SelfBroadcastPrinter(final ProxySession session) {
        super(session);
    }

    @Override
    public void completed(final List<Map.Entry<HttpHost, String>> responses) {
        DecodableByteArrayOutputStream out =
            new DecodableByteArrayOutputStream();
        CharsetEncoder encoder = session.acceptedCharset().newEncoder()
            .onMalformedInput(CodingErrorAction.REPLACE)
            .onUnmappableCharacter(CodingErrorAction.REPLACE);

        try (OutputStreamWriter outWriter =
                 new OutputStreamWriter(out, encoder))
        {
            for (int i = 0; i < responses.size(); i++) {
                if (i != 0) {
                    outWriter.write("\n-------------------\n");
                }

                Map.Entry<HttpHost, String> entry = responses.get(i);
                outWriter.write(entry.getKey().toHostString());
                outWriter.write("\n\n");
                outWriter.write(entry.getValue());
            }
        } catch (IOException ioe) {
            failed(ioe);
        }

        NByteArrayEntity entity =
            out.processWith(NByteArrayEntityFactory.INSTANCE);
        entity.setContentType(
            ContentType.TEXT_PLAIN.withCharset(
                session.acceptedCharset())
                .toString());
        session.response(HttpStatus.SC_OK, entity);
    }
}
