package ru.yandex.msearch.proxy.api.async.broadcast;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Map.Entry;

import org.apache.http.HttpHost;
import org.apache.http.concurrent.FutureCallback;
import ru.yandex.http.proxy.ProxySession;
import ru.yandex.http.util.BadRequestException;
import ru.yandex.search.rules.BasicRequestParams;
import ru.yandex.search.rules.RequestParams;
import ru.yandex.search.rules.SearchInfo;
import ru.yandex.search.rules.SearchService;

public class SelfBroadcastService
    implements SearchService<List<Entry<HttpHost, String>>, RequestParams, SearchInfo>
{
    @Override
    public RequestParams createRequestParams(
        final ProxySession session)
        throws BadRequestException
    {
        return new BasicRequestParams(0, 0, Collections.emptySet());
    }

    @Override
    public SearchInfo createSearchInfo(
        final ProxySession session,
        final RequestParams requestParams)
        throws BadRequestException
    {
        return new SearchInfo("");
    }

    @Override
    public FutureCallback<? super List<Entry<HttpHost, String>>> createCallback(
        final ProxySession session,
        final RequestParams requestParams,
        final SearchInfo searchInfo)
        throws BadRequestException
    {
        return new SelfBroadcastPrinter(session);
    }
}
