package ru.yandex.msearch.proxy.api.async.enlarge;

import java.io.IOException;

import org.apache.http.HttpException;
import org.apache.http.HttpStatus;
import ru.yandex.http.proxy.ProxyRequestHandler;
import ru.yandex.http.proxy.ProxySession;
import ru.yandex.msearch.proxy.AsyncHttpServer;
import ru.yandex.msearch.proxy.api.async.ProxyParams;

public class UserOnlineHandler implements ProxyRequestHandler {
    private final AsyncHttpServer server;

    public UserOnlineHandler(final AsyncHttpServer server) {
        this.server = server;
    }

    @Override
    public void handle(final ProxySession session)
        throws HttpException, IOException
    {
        Long uid = session.params().getLong(ProxyParams.UID);
        session.response(HttpStatus.SC_OK);
    }
}
