package ru.yandex.msearch.proxy.api.async.enlarge;

import java.io.IOException;

import java.util.List;
import java.util.Map;
import java.util.function.Function;

import org.apache.http.HttpException;
import org.apache.http.HttpHost;
import org.apache.http.HttpStatus;
import org.apache.http.message.BasicHttpRequest;

import ru.yandex.function.EmptySupplier;

import ru.yandex.http.proxy.AbstractProxySessionCallback;
import ru.yandex.http.proxy.ProxyRequestHandler;
import ru.yandex.http.proxy.ProxySession;

import ru.yandex.http.util.EmptyFutureCallback;
import ru.yandex.http.util.ErrorSuppressingFutureCallback;
import ru.yandex.http.util.MultiFutureCallback;
import ru.yandex.http.util.RequestErrorType;
import ru.yandex.http.util.ServiceUnavailableException;

import ru.yandex.http.util.nio.BasicAsyncRequestProducerGenerator;
import ru.yandex.http.util.nio.EmptyAsyncConsumerFactory;

import ru.yandex.http.util.nio.client.AsyncClient;

import ru.yandex.msearch.proxy.AsyncHttpServer;
import ru.yandex.msearch.proxy.config.EnlargeConfig;

import ru.yandex.parser.searchmap.User;

import ru.yandex.parser.uri.QueryConstructor;

import ru.yandex.search.prefix.Prefix;
import ru.yandex.search.prefix.PrefixType;

public class Your implements ProxyRequestHandler {
    private static final Function<Exception, RequestErrorType>
        ERROR_CLASSIFIER = new Function<Exception, RequestErrorType>() {
            @Override
            public RequestErrorType apply(final Exception e) {
                RequestErrorType errorType =
                    RequestErrorType.ERROR_CLASSIFIER.apply(e);
                if (errorType == RequestErrorType.HOST_NON_RETRIABLE) {
                    errorType = RequestErrorType.IO;
                }
                return errorType;
            }
        };

    private final AsyncHttpServer server;
    private final EnlargeConfig config;
    private final Map<String, Enlargeble> enlargebles;

    public Your(final AsyncHttpServer server) {
        this.server = server;
        config = server.config().enlargeConfig();
        enlargebles = config.enlargebles();
    }

    @Override
    public String toString() {
        return "Enlarge your anything (warm index)";
    }

    @Override
    public void handle(final ProxySession session) throws HttpException {
        final Prefix uid = session.params().get("uid", PrefixType.LONG);
        final MultiFutureCallback<Void> justWaitForRequestsToCompleteCallback =
            new MultiFutureCallback<>(EmptyFutureCallback.INSTANCE);
        final AsyncClient client =
            server.searchClient().adjust(session.context());
        for (Map.Entry<String, Enlargeble> entry: enlargebles.entrySet()) {
            final String service = entry.getValue().service();
            final String enlargeble = entry.getKey();
            session.logger().info("Enlarging " + enlargeble);
            User user = new User(service, uid);
            List<HttpHost> hosts = server.searchMap().searchHosts(user);
            if (hosts.isEmpty()) {
                session.logger().info("user "
                    + uid.toString() + '@' + service
                    + " is not found in searchmap");
            } else {
                final String uri = entry.getValue().apply(session.params());
                final BasicHttpRequest head = new BasicHttpRequest("HEAD", uri);
                for (HttpHost host: hosts) {
                    try {
                        client.execute(
                            host,
                            new BasicAsyncRequestProducerGenerator(head),
                            EmptyAsyncConsumerFactory.INSTANCE,
                            session.listener().createContextGeneratorFor(
                                client),
                            new ErrorSuppressingFutureCallback(
                                justWaitForRequestsToCompleteCallback
                                    .newCallback(),
                                ERROR_CLASSIFIER,
                                EmptySupplier.INSTANCE));
                    } catch (IOException e) {
                        new ServiceUnavailableException(e);
                    }
                }
            }
        }
        justWaitForRequestsToCompleteCallback.done();
        session.response(HttpStatus.SC_OK);
    }

    private static class YourResponseCallback
        extends AbstractProxySessionCallback<List<Void>>
    {
        YourResponseCallback(final ProxySession session) {
            super(session);
        }

        @Override
        public void completed(final List<Void> deadStore) {
            session.response(HttpStatus.SC_OK);
        }
    }
}
