package ru.yandex.msearch.proxy.api.async.mail;

import java.util.Collection;

import ru.yandex.http.util.BadRequestException;

import ru.yandex.parser.uri.CgiParams;
import ru.yandex.parser.uri.QueryConstructor;

public class AttachmentsSearchAttributes extends SidebarSearchAttributes {
    private static final String DP = "dp";

    public AttachmentsSearchAttributes(
        final CgiParams params,
        final Collection<String> luceneFields)
        throws BadRequestException
    {
        super(params, luceneFields);
    }

    @Override
    public String luceneGet() {
        return super.luceneGet() + ",attachmentid";
    }

    @Override
    public void appendToLuceneRequest(final QueryConstructor query)
        throws BadRequestException
    {
        query.append(DP, "const(_ empty)");
        query.append(DP, "fallback(md5,empty md5empty)");
        query.append(DP, "concat(md5empty,empty,attachname attachmentid)");
    }
}

