package ru.yandex.msearch.proxy.api.async.mail;

import java.util.concurrent.Future;

import org.apache.http.concurrent.FutureCallback;

import ru.yandex.msearch.proxy.api.async.Session;
import ru.yandex.msearch.proxy.api.async.mail.documents.Documents;
import ru.yandex.http.util.CancellableFutureProxy;
import ru.yandex.parser.uri.CgiParams;

public class BasicSearchSession implements SearchSession {
    private final RequestInfo requestInfo;
    private final CgiParams params;
    private final FutureCallback<? super Documents> callback;

    public BasicSearchSession(
        final RequestInfo requestInfo,
        final CgiParams params,
        final FutureCallback<? super Documents> callback)
    {
        this.requestInfo = requestInfo;
        this.params = params;
        this.callback = callback;
    }

    @Override
    public RequestInfo requestInfo() {
        return requestInfo;
    }

    @Override
    public Session httpSession() {
        return requestInfo.session();
    }

    @Override
    public CgiParams params() {
        return params;
    }

    @Override
    public FutureCallback<? super Documents> callback() {
        return callback;
    }

    @Override
    public SearchSession copy() {
        return new BasicSearchSession(
            requestInfo,
            new CgiParams(params),
            callback);
    }

    @Override
    public SearchSession withCallback(
        final FutureCallback<? super Documents> callback)
    {
        return new BasicSearchSession(requestInfo, params, callback);
    }
}

