package ru.yandex.msearch.proxy.api.async.mail;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

import ru.yandex.http.util.BadRequestException;

import ru.yandex.parser.string.EnumParser;
import ru.yandex.parser.string.NonEmptyValidator;

import ru.yandex.parser.uri.CgiParams;
import ru.yandex.parser.uri.QueryConstructor;
import ru.yandex.search.document.mail.FolderType;

public class DefaultSearchAttributes implements SearchAttributes {
    public static final EnumParser<FolderType>
        FOLDER_TYPE_PARSER = new EnumParser<>(FolderType.class);

    protected final boolean unread;
    protected final boolean excludeTrash;
    protected final Set<String> fids;
    protected final Set<String> lids;
    protected final Set<FolderType> folderTypes;
    protected final int requestedResultsMultipier;

    public DefaultSearchAttributes(final CgiParams params)
        throws BadRequestException
    {
        unread = params.getBoolean("unread", false);
        excludeTrash = params.getBoolean("exclude-trash", false);
        folderTypes = params.getAll(
            "folder",
            Collections.emptySet(),
            FOLDER_TYPE_PARSER,
            new HashSet<>());

        fids = params.getAll(
            "fid",
            Collections.emptySet(),
            NonEmptyValidator.INSTANCE,
            new HashSet<>());
        lids = params.getAll(
            "lid",
            Collections.emptySet(),
            NonEmptyValidator.INSTANCE,
            new HashSet<>());
        if ("pg".equals(params.getString("mdb", null))
            || (!unread && fids.isEmpty() && lids.isEmpty()))
        {
            requestedResultsMultipier = 2;
        } else {
            requestedResultsMultipier = 50;
        }
    }

    @Override
    public String luceneGet() {
        return "mid,hid,clicks_total_count,clicks_serp_count";
    }

    @Override
    public String luceneGroup() {
        return "mid";
    }

    @Override
    public String luceneMergeFunc() {
        return "none";
    }

    @Override
    public String rewriteLuceneQuery(final String query) {
        return query;
    }

    @Override
    public void appendToLuceneRequest(final QueryConstructor query)
        throws BadRequestException
    {
    }

    @Override
    public boolean onlyUnread() {
        return unread;
    }

    @Override
    public boolean excludeTrash() {
        return excludeTrash;
    }

    @Override
    public boolean excludeSpam() {
        return fids.isEmpty();
    }

    @Override
    public boolean includeHiddenTrash() {
        return folderTypes.contains(FolderType.HIDDEN_TRASH);
    }

    @Override
    public boolean excludeHiddenSubscriptions() {
        return fids.isEmpty();
    }

    @Override
    public void appendToFilterSearchRequest(final QueryConstructor query)
        throws BadRequestException
    {
        for (String fid: fids) {
            query.append("fids", fid);
        }
        for (String lid: lids) {
            query.append("lids", lid);
        }
    }

    @Override
    public int requestedResultsMultipier() {
        return requestedResultsMultipier;
    }
}

