package ru.yandex.msearch.proxy.api.async.mail;

import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Map;

import org.apache.http.Header;
import ru.yandex.http.proxy.ProxySession;
import ru.yandex.http.util.BadRequestException;
import ru.yandex.http.util.YandexHeaders;
import ru.yandex.json.dom.JsonObject;
import ru.yandex.json.dom.TypesafeValueContentHandler;
import ru.yandex.json.parser.JsonException;
import ru.yandex.parser.uri.CgiParams;

public class ExperimentsFlagsParser {
    private static final String EMPTY_STRING = "e30=";

    public static void apply(
        final ProxySession session)
        throws BadRequestException
    {
        apply(session, session.params());
    }

    public static void apply(
        final ProxySession session,
        final CgiParams params)
        throws BadRequestException
    {
        Header header =
            session.request().getFirstHeader(YandexHeaders.X_FEAUTURE_PARAMS);
        if (header != null) {
            String value = header.getValue();
            if (value == null || EMPTY_STRING.equalsIgnoreCase(value)) {
                return;
            }

            byte[] data = Base64.getDecoder().decode(value);
            String dataStr = new String(data, StandardCharsets.UTF_8);
            try {
                session.logger().info(dataStr);

                //FIXME could use thread local parser
                JsonObject flagsRoot =
                    TypesafeValueContentHandler.parse(dataStr);
                for (Map.Entry<String, JsonObject> entry
                    : flagsRoot.asMap().entrySet())
                {
                    String flagKey = entry.getKey();
                    String flagValue = entry.getValue().asStringOrNull();

                    if (params.containsKey(flagKey)) {
                        session.logger().warning(
                            "Override for key " + flagKey);
                    }

                    params.replace(flagKey, flagValue);
                }
            } catch (JsonException je) {
                session.logger().warning(
                    "Failed to parse exp flags " + dataStr);
            }
        }
    }
}
