package ru.yandex.msearch.proxy.api.async.mail;

import ru.yandex.http.util.BadRequestException;
import ru.yandex.parser.uri.CgiParams;

import ru.yandex.util.string.StringUtils;

public class ImapSearchAttributes extends DefaultSearchAttributes {
    public ImapSearchAttributes(final CgiParams params)
        throws BadRequestException
    {
        super(params);
    }

    @Override
    public String luceneGet() {
        return "mid";
    }

    @Override
    public String rewriteLuceneQuery(final String query) {
        if (fids.size() > 0) {
            return '(' + query + ") AND fid:("
                + StringUtils.join(fids, ' ') + ')';
        } else {
            return query;
        }
    }

    @Override
    public boolean excludeHiddenSubscriptions() {
        return false;
    }
}
