package ru.yandex.msearch.proxy.api.async.mail;

import java.util.List;

public class PerfieldScorer {
    public static final String[] FIELD_POSTFIXES =
        {
            "_exact_freq", "_exact_hits", "_exact_score",
            "_non_exact_freq", "_non_exact_hits", "_non_exact_score"
        };

    private final List<String> fields;

    public PerfieldScorer(final List<String> fields) {
        this.fields = fields;
    }

    public StringBuilder applyGetFields(final StringBuilder sb) {
        if (sb.length() != 0) {
            sb.append(',');
        }

        for (String field: fields) {
            for (int i = 0; i < FIELD_POSTFIXES.length; i++) {
                sb.append('#');
                sb.append(field);
                sb.append(FIELD_POSTFIXES[i]);
                sb.append(',');
            }
        }

        if (sb.length() != 0) {
            sb.setLength(sb.length() - 1);
        }

        return sb;
    }

    public String buildScorer() {
        StringBuilder sb = new StringBuilder("perfield(");
        for (String field: fields) {
            sb.append(field);
            sb.append(',');
        }

        sb.setLength(sb.length() - 1);
        sb.append(')');
        return sb.toString();
    }
}
