package ru.yandex.msearch.proxy.api.async.mail;

import ru.yandex.blackbox.BlackboxUserinfo;
import ru.yandex.http.util.BadRequestException;
import ru.yandex.msearch.proxy.api.async.ProxyParams;
import ru.yandex.parser.string.EnumParser;
import ru.yandex.parser.uri.CgiParams;

public enum Product {
    BP,
    PDD,
    CORP,
    UNKNOWN;

    public static Product parseWithException(
        final CgiParams params)
        throws BadRequestException
    {
        Long uidOrSuid;
        uidOrSuid = params.getLong(ProxyParams.UID, null);
        if (uidOrSuid == null) {
            uidOrSuid = params.getLong(ProxyParams.SUID);
        }

        return parse(uidOrSuid);
    }

    public static Product parse(final CgiParams params) {
        try {
            return parseWithException(params);
        } catch (BadRequestException bre) {
            return Product.UNKNOWN;
        }
    }

    public static Product parse(final String value) {
        return new EnumParser<>(Product.class).apply(value);
    }

    public static Product parse(final long uidOrSuid) {
        Product product;

        if (BlackboxUserinfo.corp(uidOrSuid)) {
            product = CORP;
        } else if (BlackboxUserinfo.pdd(uidOrSuid)) {
            product = PDD;
        } else {
            product = BP;
        }

        return product;
    }
}
