package ru.yandex.msearch.proxy.api.async.mail;

import ru.yandex.http.util.BadRequestException;

import ru.yandex.parser.uri.QueryConstructor;

public interface SearchAttributes {
    // lucene request adjustment
    String luceneGet();

    String luceneGroup();

    String luceneMergeFunc();

    String rewriteLuceneQuery(String query);

    // any additional query adjustment
    void appendToLuceneRequest(QueryConstructor query)
        throws BadRequestException;

    // filter search request adjustment
    boolean onlyUnread();

    boolean excludeTrash();

    boolean excludeSpam();

    // https://st.yandex-team.ru/PS-3723
    default boolean includeHiddenTrash() {
        return false;
    }

    default boolean excludePending() {
        return false;
    }

    boolean excludeHiddenSubscriptions();

    // expected to add fids and lids filters
    void appendToFilterSearchRequest(QueryConstructor query)
        throws BadRequestException;

    // Usually about one forth of emails remains after filtration, but this
    // depends on other request options like unread flag and fids and lids sets
    int requestedResultsMultipier();
}

