package ru.yandex.msearch.proxy.api.async.mail;

import java.util.Locale;

import ru.yandex.parser.string.EnumParser;
import ru.yandex.parser.uri.CgiParams;

public enum Side {
    WEB,
    // phones
    TOUCHSM,
    // tablets
    TOUCHTAB,
    MOBILE,
    UNKNOWN;

    public static Side parse(final CgiParams params) {
        return parse(params.getString("side", null));
    }

    public static Side parse(final String sideStr) {
        Side side = Side.UNKNOWN;
        if (sideStr != null) {
            String sideUpped = sideStr.toUpperCase(Locale.ENGLISH);
            if (sideUpped.startsWith("WEB")) {
                side = Side.WEB;
            } else {
                try {
                    side = new EnumParser<>(Side.class).apply(sideUpped);
                } catch (IllegalArgumentException iae) {
                }
            }
        }

        return side;
    }
}
