package ru.yandex.msearch.proxy.api.async.mail;

import java.util.Collection;

import ru.yandex.http.util.BadRequestException;

import ru.yandex.parser.uri.CgiParams;

public class SidebarSearchAttributes extends DefaultSearchAttributes {
    protected final Collection<String> luceneFields;

    public SidebarSearchAttributes(
        final CgiParams params,
        final Collection<String> luceneFields)
        throws BadRequestException
    {
        super(params);
        this.luceneFields = luceneFields;
    }

    @Override
    public String luceneGet() {
        StringBuilder sb = new StringBuilder(super.luceneGet());
        for (String field: luceneFields) {
            sb.append(',');
            sb.append(field);
        }
        return new String(sb);
    }

    @Override
    public String luceneMergeFunc() {
        return "values";
    }

    @Override
    public boolean excludeSpam() {
        return fids.isEmpty();
    }

    @Override
    public boolean excludeHiddenSubscriptions() {
        return false;
    }
}

