package ru.yandex.msearch.proxy.api.async.mail;

import java.util.Collections;
import java.util.Comparator;
import java.util.Set;

import ru.yandex.http.util.BadRequestException;

import ru.yandex.msearch.proxy.api.async.mail.documents.Document;

import ru.yandex.parser.uri.QueryConstructor;

public enum SingleFieldSortOrder implements Comparator<Document>, SortOrder {
    DEFAULT("received_date", false, true),
    DATE(DEFAULT.field, false, true),
    DATE1(DATE.field, true, true),
    SIZE("size", false, true),
    SIZE1(SIZE.field, true, true),
    SUBJECT("hdr_subject", false, false),
    SUBJECT1(SUBJECT.field, true, false),
    FROM("hdr_from", false, false),
    FROM1(FROM.field, true, false),
    RLV(DEFAULT.field, false, true);

    private final String field;
    private final boolean asc;
    private final boolean number;

    private SingleFieldSortOrder(
        final String field,
        final boolean asc,
        final boolean number)
    {
        this.field = field;
        this.asc = asc;
        this.number = number;
    }

    private long asLong(final String value) {
        if (value == null) {
            return Long.MIN_VALUE;
        } else {
            try {
                return Long.parseLong(value);
            } catch (NumberFormatException e) {
                return Long.MIN_VALUE;
            }
        }
    }

    private String orEmpty(final String value) {
        if (value == null) {
            return "";
        } else {
            return value;
        }
    }

    private int doCompare(final Document lhs, final Document rhs) {
        String left = lhs.doc().attrs().get(field);
        String right = rhs.doc().attrs().get(field);
        int cmp;
        if (number) {
            cmp = Long.compare(asLong(left), asLong(right));
        } else {
            cmp = orEmpty(left).compareTo(orEmpty(right));
        }
        if (cmp == 0) {
            cmp = lhs.id().compareTo(rhs.id());
        }
        return cmp;
    }

    @Override
    public int compare(final Document lhs, final Document rhs) {
        if (asc) {
            return doCompare(lhs, rhs);
        } else {
            return doCompare(rhs, lhs);
        }
    }

    @Override
    public Set<String> readFields() {
        return Collections.singleton(field);
    }

    @Override
    public void appendTo(final QueryConstructor query)
        throws BadRequestException
    {
        query.append("sort", field);
        if (field.equals("received_date")) {
            query.append("collector", "pruning(received_day_p)");
        } else {
            query.append("collector", "pruning");
        }
        if (asc) {
            query.append("asc", "true");
        }
    }

    @Override
    public Comparator<Document> comparator() {
        return this;
    }
}

