package ru.yandex.msearch.proxy.api.async.mail.chemodan;

import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

import ru.yandex.msearch.proxy.document.Document;

public abstract class AbstractChemodanDocument
    implements Comparable<AbstractChemodanDocument>
{
    private static final Comparator<String> ID_COMPARATOR =
        Comparator.nullsFirst(Comparator.naturalOrder());

    private static final Set<String> INT_FIELDS =
        new HashSet<>(
            Arrays.asList(
                "received_date",
                "mid",
                "attachsize_b"));

    protected final Map<String,String> metaAttrs = new LinkedHashMap<>();
    protected final Map<String,String> attrs = new LinkedHashMap<>();

    protected final boolean folder;
    protected String orderField = null;
    protected boolean intCompare;
    protected long orderFieldInt;

    public AbstractChemodanDocument(final boolean folder) {
        this.folder = folder;
    }

    public void metaAttr(final String key, final String value ) {
        metaAttrs.put(key, value);
    }

    public void attr(final String key, final String value) {
        attrs.put(key, value);
    }

    public String attr(final String key) {
        return attrs.get(key);
    }

    public String metaAttr(final String key) {
        return metaAttrs.get(key);
    }

    public Map<String,String> metaAttrs() {
        return metaAttrs;
    }

    public Map<String, String> attrs() {
        return attrs;
    }

    public final String id()
    {
        return attr("id");
    }

    public final String parentId()
    {
        return metaAttr("parentId");
    }

    public boolean folder() {
        return folder;
    }

    public void setOrderField(final String field) {
        orderField = attrs.get(field);
        if (INT_FIELDS.contains(field)) {
            try {
                orderFieldInt = Long.parseLong(orderField);
                intCompare = true;
            } catch (Exception e) {
            }
        } else {
            intCompare = false;
        }
    }

    @Override
    public int compareTo(final AbstractChemodanDocument o) {
        int cmp;
        if (orderField == null) {
            if (o.orderField == null) {
                cmp = 0;
            } else {
                cmp = -1;
            }
        } else if (o.orderField == null) {
            cmp = 1;
        } else if (intCompare && o.intCompare) {
            cmp = Long.compare(orderFieldInt, o.orderFieldInt);
        } else {
            cmp = orderField.compareTo(o.orderField);
        }

        if (cmp == 0) {
            cmp = ID_COMPARATOR.compare(id(), o.id());
        }

        return cmp;
    }

    @Override
    public String toString() {
        return "AbstractChemodanDocument{" +
            "metaAttrs=" + metaAttrs +
            ", attrs=" + attrs +
            '}';
    }
}
