package ru.yandex.msearch.proxy.api.async.mail.chemodan;

import java.util.List;

import org.apache.http.concurrent.FutureCallback;

import ru.yandex.http.util.BadRequestException;
import ru.yandex.msearch.proxy.AsyncHttpServer;

public abstract class AbstractChemodanHandler {
    protected final ChemodanFoldersFetcher foldersFetcher;
    protected final AsyncHttpServer server;

    public AbstractChemodanHandler(final AsyncHttpServer server) {
        this.server = server;
        this.foldersFetcher = new ChemodanFoldersFetcher(server);
    }

    protected void collectFiles(
        final ChemodanContext context,
        final boolean desc,
        final String sortField,
        final int length,
        final int offset,
        final String request,
        final List<String> filterFids,
        final FutureCallback<ChemodanSearcherDocuments> callback)
        throws BadRequestException
    {
        SearcherContext searcherContext =
            new SearcherContext(
                context,
                request,
                length,
                offset,
                "mid",
                sortField,
                filterFids,
                desc);

        ChemodanSearcher searcher =
            new ChemodanSearcher(
                searcherContext,
                callback);

        searcher.sendNextRequest();
    }

    protected void collectFiles(
        final ChemodanContext context,
        final String request,
        final List<String> filterFids,
        final FutureCallback<ChemodanSearcherDocuments> callback)
        throws BadRequestException
    {
        collectFiles(
            context,
            context.desc(),
            context.sortAttr().luceneName(),
            context.length(),
            context.offset(),
            request,
            filterFids,
            callback);
    }

    protected static String applyFilter(String request) {
        String filter =
            "((disposition_type:inline AND "
                + "(headers:\"_$XHIDENX$_content-id:\" OR headers:content-id\\:*)) "
                + "OR attachname:narod_attachment_links.html "
                + "OR mimetype:application/pkcs7-signature "
                + "OR attachname:smime.p7s "
                + "OR headers:\"_$XHIDENX$_content-id:\" "
                + "OR headers:content-id\\:* "
                + "OR headers:\"_$XHIDENX$_content-location:\" "
                + "OR headers:content-location\\:* "
                + "OR headers:\"_$XHIDENX$_list-unsubscribe:\" "
                + "OR headers:list-unsubscribe\\:* "
                + "OR headers:\"_$XHIDENX$_list-id:\" "
                + "OR headers:list-id\\:* "
                + "OR headers:\"_$XHIDENX$_precedence: list\" "
                + "OR headers:\"_$XHIDENX$_precedence: List\" "
                + "OR headers:precedence\\:\\ \\ list* "
                + "OR headers:precedence\\:\\ List "
                + "OR headers:\"_$XHIDENX$_precedence: junk\" "
                + "OR headers:\"_$XHIDENX$_precedence: Junk\" "
                + "OR headers:precedence\\:\\ junk "
                + "OR headers:precedence\\:\\ Junk "
                + "OR headers:\"_$XHIDENX$_precedence: bulk\" "
                + "OR headers:\"_$XHIDENX$_precedence: Bulk\" "
                + "OR headers:precedence\\:\\ bulk "
                + "OR headers:precedence\\:\\ Bulk)";
        if (request == null || request.isEmpty()) {
            request = "attachname:*";
        }
        return '(' + request + ") AND NOT " + filter;
    }
}
