package ru.yandex.msearch.proxy.api.async.mail.chemodan;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;

import org.apache.http.concurrent.FutureCallback;

import ru.yandex.http.util.AbstractFilterFutureCallback;
import ru.yandex.json.dom.JsonMap;
import ru.yandex.json.dom.JsonObject;
import ru.yandex.json.parser.JsonException;
import ru.yandex.msearch.proxy.api.async.mail.documents.Document;
import ru.yandex.msearch.proxy.document.WmiFieldUnificator;
import ru.yandex.msearch.proxy.ora.wmi.fields.WmiField;
import ru.yandex.search.result.SearchDocument;

public abstract class AbstractChemodanSearchCallback
    extends AbstractFilterFutureCallback<ChemodanSearcherDocuments, AsyncChemodanCollector>
{
    protected final ChemodanContext context;
    protected final AsyncChemodanCollector collector;
    protected final Collection<String> folders;
    protected final boolean search;
    protected final String path;

    public AbstractChemodanSearchCallback(
        final ChemodanContext context,
        final AsyncChemodanCollector collector,
        final Collection<String> folders,
        final boolean search,
        final String path,
        final FutureCallback<? super AsyncChemodanCollector> callback)
    {
        super(callback);
        this.context = context;
        this.collector = collector;
        this.folders = folders;
        this.search = search;
        this.path = path;
    }

    protected final boolean checkAttach(final Map<String, String> doc) {
        String name = doc.get("attachname");
        if (name == null) {
            return false;
        }

        return true;
    }

    protected Map<String, String> convertEnvelope(
        final JsonMap envelope)
        throws JsonException {
        final Map<String, String> result = new LinkedHashMap<>(envelope.size());

        for (Map.Entry<String, JsonObject> entry
            : envelope.entrySet()) {
            String key = WmiFieldUnificator.get(entry.getKey());
            switch (entry.getKey()) {
                case WmiField.FROM:
                case WmiField.TO:
                case WmiField.CC:
                case WmiField.BCC:
                case WmiField.REPLY_TO:
                    StringBuilder sb = new StringBuilder();
                    for (JsonObject item : entry.getValue().asList()) {
                        JsonMap map = item.asMap();
                        String local = map.getString(WmiField.EMAIL_LOCAL);
                        String domain = map.getString(WmiField.EMAIL_DOMAIN);
                        String display = map.getString(WmiField.EMAIL_DISPLAY);
                        String email =
                            WmiField.constructEmail(domain, local, display);
                        sb.append(email);
                        sb.append(',');
                    }

                    if (sb.length() > 0) {
                        sb.setLength(sb.length() - 1);
                    }

                    result.put(key, sb.toString());

                    break;
                case WmiField.LABELS:
                case WmiField.TYPES:
                    StringBuilder typesSb = new StringBuilder();
                    for (JsonObject item : entry.getValue().asList()) {
                        typesSb.append(item.asString());
                        typesSb.append('\n');
                    }

                    if (typesSb.length() > 0) {
                        typesSb.setLength(typesSb.length() - 1);
                    }

                    result.put(key, typesSb.toString());
                    break;

                case WmiField.SPECIAL_LABELS:
                case WmiField.ATTACHMENTS:
                    break;
                default:
                    switch (entry.getValue().type()) {
                        case LONG:
                            result.put(
                                key,
                                String.valueOf(entry.getValue().asLong()));
                            break;
                        case BOOLEAN:
                            result.put(
                                key,
                                String.valueOf(entry.getValue().asBoolean()));
                            break;
                        case STRING:
                            result.put(
                                key,
                                entry.getValue().asString());
                            break;
                    }
                    break;
            }
        }

        return result;
    }

    public void fillCollector(final ChemodanSearcherDocuments result) {
        for (Document document : result.docs()) {
            Map<String, String> fsData;
            try {
                fsData = convertEnvelope(document.envelope());
            } catch (JsonException e) {
                failed(e);
                return;
            }

            String fid = fsData.get("fid");

            FolderChemodanDocument folder;
            if (context.folders() != null) {
                folder = context.folders().foldersFidMap().get(fid);
            } else {
                folder = null;
            }

            int count = 0;
            boolean collect = false;
            if (search) {
                if (folders.isEmpty() || folders.contains(fid)) {
                    collect = true;
                }
            } else {
                if (fid.equals(path)) {
                    collect = true;
                }
            }

            if (!collect) {
                context.logger().info(
                    "Do not collecting folders:"
                        + folders + " "
                        + fid + " " + path);
            }

            Map<String, String> parent =
                new LinkedHashMap<>(document.doc().attrs());
            parent.putAll(fsData);
            if (checkAttach(document.doc().attrs())) {
                count++;
                if (collect) {
                    collector.collect(
                        new AttachChemodanDocument(
                            context,
                            parent,
                            null,
                            folder));
                }
            }

            if (document.doc().mergedDocs().size() > 0) {
                for (SearchDocument mergedDoc : document.doc().mergedDocs()) {
                    if (checkAttach(mergedDoc.attrs())) {
                        Map<String, String> doc =
                            new LinkedHashMap<>(mergedDoc.attrs());
                        doc.putAll(fsData);
                        count++;
                        if (collect) {
                            collector.collect(
                                new AttachChemodanDocument(
                                    context,
                                    doc,
                                    parent,
                                    folder));
                        }
                    }
                }
            }

            if (folder != null) {
                folder.incFileCount(count);
            }
        }
    }
}
