package ru.yandex.msearch.proxy.api.async.mail.chemodan;

import java.util.Comparator;
import java.util.Map;
import java.util.TreeMap;

import ru.yandex.msearch.proxy.api.chemodan.Attr;
import ru.yandex.msearch.proxy.api.chemodan.ChemodanCollector;
import ru.yandex.msearch.proxy.api.chemodan.ChemodanDocument;

public class AsyncChemodanCollector {
    private int totalCount = 0;
    private TreeMap<AbstractChemodanDocument, AbstractChemodanDocument> docs;
    private DocComparator comparator;
    private Attr sortAttr;
    private boolean ascending;
    private boolean root = true;
    private FolderChemodanDocument currentFolder = null;
    private int maxEntries;

    public AsyncChemodanCollector(
        final Attr sortAttr,
        final boolean ascending,
        final int maxEntries)
    {
        this.sortAttr = sortAttr;
        this.ascending = ascending;
        this.maxEntries = maxEntries;
        comparator = new DocComparator();
        docs = new TreeMap<>(comparator);
    }

    public synchronized void incTotalCount(int inc) {
        totalCount += inc;
    }

    public synchronized int getTotalCount() {
        return totalCount;
    }

    public synchronized int getCount() {
        return docs.keySet().size();
    }

    public synchronized Map<AbstractChemodanDocument, AbstractChemodanDocument> hits() {
        return docs;
    }

    public synchronized void collect(final AbstractChemodanDocument doc) {
        if (doc == null) {
            return;
        }

        doc.setOrderField(sortAttr.diskName());
        docs.put(doc, doc);

        incTotalCount(1);
        if (docs.size() > maxEntries) {
            docs.remove(docs.lastKey());
        }
    }

    public synchronized void setCurrentFolder(
        final FolderChemodanDocument doc)
    {
        currentFolder = doc;
    }

    public synchronized FolderChemodanDocument getCurrentFolder() {
        return currentFolder;
    }

    @SuppressWarnings("unchecked")
    private class DocComparator
        implements Comparator<AbstractChemodanDocument>
    {
        public DocComparator() {
        }

        @Override
        public int compare(
            final AbstractChemodanDocument a,
            final AbstractChemodanDocument b)
        {
            if (a.equals(b)) {
                return 0;
            }

            //folders are allways on top
            if (a.folder() && !b.folder()) {
                return -1;
            } else if (b.folder() && !a.folder()) {
                return 1;
            }

            int cmp;
            if (ascending) {
                cmp = a.compareTo(b);
            } else {
                cmp = b.compareTo(a);
            }

            return cmp;
        }
    }

    @Override
    public String toString() {
        return "AsyncChemodanCollector{" +
            "totalCount=" + totalCount +
            ", docs=" + docs +
            ", comparator=" + comparator +
            ", sortAttr=" + sortAttr +
            ", ascending=" + ascending +
            ", root=" + root +
            ", currentFolder=" + currentFolder +
            ", maxEntries=" + maxEntries +
            '}';
    }
}
