package ru.yandex.msearch.proxy.api.async.mail.chemodan;

import java.util.Map;
import java.util.logging.Level;

import org.apache.http.HttpException;

import ru.yandex.msearch.proxy.api.chemodan.ChemodanMailSearcher;
import ru.yandex.msearch.proxy.logger.Logger;

public class AttachChemodanDocument extends AbstractChemodanDocument {
    private final Map<String, String> parent;
    private final String ctime;
    private FolderChemodanDocument folder;
    private final String id;
    private final String name;
    private final String mid;
    private final String hid;
    private final String size;
    private final String type;
    private final String stid;
    private final ChemodanContext context;

    public AttachChemodanDocument(
        final ChemodanContext context,
        final Map<String, String> doc,
        final Map<String, String> parent,
        final FolderChemodanDocument folder)
    {
        super(false);

        this.context = context;
        this.parent = parent;
        this.folder = folder;

        if (parent != null) {
            ctime = parent.get("received_date");
        } else {
            ctime = doc.get("received_date");
        }

        attrs.put("ctime", ctime);
        attrs.put("source", "mail");

        if (parent != null) {
            metaAttrs.putAll(parent);
        }

        metaAttrs.putAll(doc);
        mid = doc.get("mid");
        hid = getHid(doc);
        id = ChemodanMailSearcher.encodeFileId(mid + "/" + hid);
        name = doc.get("attachname");
        String attchSizeStr = doc.get("attachsize_b");
        if (attchSizeStr == null) {
            context.logger().warning("Null attachsize for " + doc);
            // setting to filter search if it present
            attchSizeStr = doc.get("size");
            if (attchSizeStr != null) {
                size = String.valueOf(Integer.parseInt(attchSizeStr));
            } else {
                size = "0";
            }
        } else {
            size = String.valueOf(Integer.parseInt(attchSizeStr));
        }

        type = doc.get("mimetype");

        if (folder != null) {
            metaAttrs.put(
                "fullpath",
                folder.metaAttr("fullpath") + "/" + id);
            metaAttrs.put(
                "fullname",
                folder.metaAttr("fullname") + "/" + name);
        }

        String stid;
        if (parent != null) {
            stid = parent.get("st_id");
        } else {
            stid = doc.get("st_id");
        }
        if (stid == null) {
            Logger.err("Document <" + mid + "> contains no st_id");
            Logger.err(doc.toString());
            stid = "1.2.3";
        }
        if (stid.startsWith("mulca:2:")) {
            stid = stid.substring(8);
        }

        this.stid = stid;

        attrs.put("id", id);
        attrs.put("name", name);
        attrs.put("size", size);
        attrs.put("type", type);
        String url;
        try {
            url = makeUrl(stid);
        } catch (HttpException bre) {
            context.logger().log(
                Level.WARNING,
                "Failed to create attach url",
                bre);
            url = "";

            context.server().failedChemodanSid().accept(1);
        }
        metaAttrs.put("url", url);
        metaAttrs.put("hid", hid);
        metaAttrs.put("stid", stid);
        metaAttrs.put("part", hid);
        if (previewableFile(this)) {
            metaAttrs.put("preview", url + "&thumb=y");
        }
    }

    public final String makeUrl(final String stid) throws HttpException {
        StringBuilder sb = new StringBuilder();
        sb.append(context.attachUrlBase());
        sb.append(name);
        sb.append("?sid=");
        sb.append(context.generateSid(stid, hid, mid));
        sb.append("&name=");
        sb.append(name);
        sb.append("&ids=");
        sb.append(mid);
        return new String(sb);
    }

    private final String getHid(final Map<String, String> doc) {
        String url = doc.get("url");
        int slashPos = url.indexOf('/');
        if (slashPos == -1 || slashPos >= url.length()) {
            return "0";
        }

        return url.substring(slashPos + 1);
    }

    private final boolean previewableFile(
        final AttachChemodanDocument file)
    {
        String type = file.attr("type");
        if (type != null && type.startsWith("image")) {
            return true;
        }
        String extention = file.attr("name");
        if (extention == null) {
            return false;
        }
        int dotPos = extention.lastIndexOf('.');
        if (dotPos == -1) {
            return false;
        }
        if (dotPos == extention.length() - 1) {
            return false;
        }
        extention = extention.substring(dotPos + 1).toLowerCase();
        if (context.config().previewableExtensions().contains(extention)) {
            return true;
        }

        return false;
    }
}
