package ru.yandex.msearch.proxy.api.async.mail.chemodan;

import javax.crypto.Cipher;
import javax.crypto.Mac;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

import java.net.URLEncoder;
import java.security.SecureRandom;
import java.util.Map;

import org.apache.http.HttpException;
import org.apache.http.HttpStatus;
import ru.yandex.http.util.ServerException;
import ru.yandex.io.StringBuilderWriter;
import ru.yandex.json.dom.JsonMap;
import ru.yandex.json.dom.JsonObject;
import ru.yandex.json.dom.TypesafeValueContentHandler;
import ru.yandex.json.writer.JsonType;
import ru.yandex.json.writer.JsonWriter;
import ru.yandex.msearch.proxy.api.chemodan.Base64;

public class AttachShieldMailPS3183 implements AttachShield {
    private final Cipher cipher;
    private final Mac mac;
    private final SecretKeySpec aesKey;
    private final String aesKeyId;
    private final SecretKeySpec hmacKey;
    private final String hmacKeyId;
    private int timeout;
    private final SecureRandom secureRandom;
    private final JsonWriter jsonWriter;
    private final StringBuilder jsonSb;
    private final byte[] iv = new byte[16];

    public AttachShieldMailPS3183(int timeout) throws HttpException {
        this(
            System.getenv().get("ATTACHSID_AES_KEY"),
            System.getenv().get("ATTACHSID_HMAC_KEY"),
            timeout);
    }

    public AttachShieldMailPS3183(
        final String aesKeyStr,
        final String hmacKeyStr,
        int timeout)
        throws HttpException
    {
        this.timeout = timeout;

        secureRandom = new SecureRandom();
        try {
            JsonMap aesKeyMap =
                TypesafeValueContentHandler.parse(aesKeyStr).asMap();
            Map.Entry<String, JsonObject> aesKeyEntry
                = aesKeyMap.entrySet().iterator().next();

            aesKey = new SecretKeySpec(
                Base64.decode(aesKeyEntry.getValue().asString()),
                "RawBytes");

            aesKeyId = aesKeyEntry.getKey();

            JsonMap hmacKeyMap =
                TypesafeValueContentHandler.parse(hmacKeyStr).asMap();

            Map.Entry<String, JsonObject> hmacKeyEntry
                = hmacKeyMap.entrySet().iterator().next();

            hmacKey = new SecretKeySpec(
                Base64.decode(hmacKeyEntry.getValue().asString()),
                "RawBytes");
            hmacKeyId = hmacKeyEntry.getKey();

            cipher = Cipher.getInstance("AES/CBC/PKCS7Padding");
            mac = Mac.getInstance("HmacSHA256");
            mac.init(hmacKey);
            jsonSb = new StringBuilder();
            jsonWriter =
                JsonType.NORMAL.create(new StringBuilderWriter(jsonSb));
        } catch (Exception e) {
            throw new ServerException(
                HttpStatus.SC_INTERNAL_SERVER_ERROR,
                "Can't initialize attachshield: " + e.getMessage(),
                e);
        }
    }

    @Override
    public String encode(
        final String stid,
        final String hid,
        final String mid,
        final long uid)
        throws HttpException
    {
        try {
            return encode(hid, mid, uid);
        } catch (Exception e) {
            e.printStackTrace();

            throw new ServerException(
                HttpStatus.SC_INTERNAL_SERVER_ERROR,
                "Failed to encode attach",
                e);
        }
    }

    public String encode(
        final String jsonPart,
        final byte[] iv)
        throws Exception
    {
        IvParameterSpec ivSpec = new IvParameterSpec(iv);
        cipher.init(Cipher.ENCRYPT_MODE, aesKey, ivSpec);
        byte[] raw_aes_sid = cipher.doFinal(jsonPart.getBytes());
        byte[] forhmac = new byte[iv.length + raw_aes_sid.length];
        System.arraycopy(iv, 0, forhmac, 0, iv.length);
        System.arraycopy(raw_aes_sid, 0, forhmac, iv.length, raw_aes_sid.length);

        jsonSb.setLength(0);
        jsonWriter.reset();
        jsonSb.append("aes_sid:");
        jsonWriter.startObject();
        jsonWriter.key("aesKeyId");
        jsonWriter.value(aesKeyId);
        jsonWriter.key("hmacKeyId");
        jsonWriter.value(hmacKeyId);
        jsonWriter.key("ivBase64");
        jsonWriter.value(encodeBase64(iv));
        jsonWriter.key("sidBase64");
        jsonWriter.value(encodeBase64(raw_aes_sid));
        jsonWriter.key("hmacBase64");
        jsonWriter.value(encodeBase64(mac.doFinal(forhmac)));
        jsonWriter.endObject();
        jsonWriter.flush();

        byte[] rawSid = (jsonSb.toString()).getBytes();
        return URLEncoder.encode(encodeChars4Opera(encodeBase64(rawSid)));
    }

    public String jsonPart(
        final String hid,
        final String mid,
        final long uid)
    {
        StringBuilder sb = new StringBuilder(128);
        sb.append("single_message_part:{\"ts\":");
        sb.append((System.currentTimeMillis() / 1000 + timeout));
        sb.append(",\"uid\":\"");
        sb.append(uid);
        sb.append("\",\"mid\":\"");
        sb.append(mid);
        sb.append("\",\"hid\":\"");
        sb.append(hid);
        sb.append("\"}");
        return sb.toString();
    }

    public String encode(
        final String hid,
        final String mid,
        final long uid)
        throws Exception
    {
        secureRandom.nextBytes(iv);

        String jsonPart = jsonPart(hid, mid, uid);
        return encode(jsonPart, iv);
    }

    private String encodeBase64(byte[] in) {
        return Base64.encode(in);
    }

    private String encodeChars4Opera(String in)
    {
        return in.replace('+', '*');
    }
}
