package ru.yandex.msearch.proxy.api.async.mail.chemodan;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;

import org.apache.http.concurrent.FutureCallback;

public class ChemodanSearchCallback
    extends AbstractChemodanSearchCallback
{
    private final ChemodanSearchContext context;

    public ChemodanSearchCallback(
        final ChemodanSearchContext context,
        final Collection<String> folders,
        final boolean search,
        final String path,
        final FutureCallback<? super AsyncChemodanCollector> callback)
    {
        super(context, context.collector(), folders, search, path, callback);

        this.context = context;
    }

    private void collectFolders() {
        if (!context.requestStr().isEmpty()) {
            //This is another one ugly hack as we must collect
            // requested folder regardless of found files.
            if (path.isEmpty()) {
                ChemodanSearchHandler.collectFolders(
                    context,
                    path,
                    new ArrayList<>(folders),
                    true);
            } else {
                folders.remove(path);
                List<String> pathList = new LinkedList<String>();
                pathList.add(path);
                ChemodanSearchHandler.collectFolders(context, path, pathList, false);
                ChemodanSearchHandler.collectFolders(
                    context,
                    path,
                    new ArrayList<>(folders),
                    true);
            }
        } else {
            ChemodanSearchHandler.collectFolders(
                context,
                path,
                new ArrayList<>(folders),
                false);
        }
    }

    @Override
    public void completed(final ChemodanSearcherDocuments result) {
        context.logger().info("Backend Search completed");
        try {
            super.fillCollector(result);

            if (context.tree()) {
                collectFolders();
            }

            callback.completed(collector);
        } catch (Exception e) {
            callback.failed(e);
        }
    }
}
