package ru.yandex.msearch.proxy.api.async.mail.chemodan;

import java.util.LinkedHashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;

import org.apache.http.HttpException;
import org.apache.http.client.protocol.HttpClientContext;

import ru.yandex.blackbox.BlackboxUserinfo;
import ru.yandex.http.proxy.ProxySession;
import ru.yandex.http.util.BadRequestException;
import ru.yandex.msearch.proxy.AsyncHttpServer;
import ru.yandex.msearch.proxy.api.async.ProxyParams;
import ru.yandex.msearch.proxy.api.chemodan.AttachShieldOld;
import ru.yandex.msearch.proxy.api.chemodan.Attr;
import ru.yandex.msearch.proxy.config.ImmutableChemodanConfig;
import ru.yandex.parser.string.CollectionParser;
import ru.yandex.parser.string.NonEmptyValidator;
import ru.yandex.parser.string.NonNegativeIntegerValidator;
import ru.yandex.parser.string.PositiveIntegerValidator;
import ru.yandex.parser.uri.CgiParams;

public class ChemodanSearchContext extends ChemodanContext {
    private static final CollectionParser<String, Set<String>, Exception>
        STRING_SET_PARSER =
        new CollectionParser<>(
            NonEmptyValidator.TRIMMED, LinkedHashSet::new);

    private final int length;
    private final int offset;
    private final int toFind;
    private final String path;
    private final String requestStr;
    private final boolean tree;
    private final boolean desc;
    private final AsyncChemodanCollector collector;
    private final Attr sortAttr;

    public ChemodanSearchContext(
        final AsyncHttpServer server,
        final ProxySession session)
        throws BadRequestException
    {
        super(server, session);

        CgiParams params = session.params();

        this.requestStr = params.getString(ProxyParams.REQUEST, "");

        String defaultSort = Attr.CTIME.diskName();
        if (requestStr.isEmpty()) {
            defaultSort =  Attr.NAME.diskName();
        }

        String sort = params.getString("sort", defaultSort);
        this.desc =
            "desc".equalsIgnoreCase(params.getString("order", null));
        boolean tree = params.getBoolean("tree", true);
        if (params.getString("newstyle", null) == null
            && !requestStr.isEmpty())
        {
            tree = false;
        }

        this.tree = tree;

        int toFind = 9999999;
        offset =
            params.get("offset", 0, NonNegativeIntegerValidator.INSTANCE);
        Integer length = params.getInt("amt", -1);
        if (length < 0) {
            length =
                params.get("length", 9999999, PositiveIntegerValidator.INSTANCE);
        }

        this.length = length;

        if (!params.getBoolean("precise-resources-count", false)) {
            toFind = offset + length + 1;
        }

        this.toFind = toFind;

        sortAttr = Attr.resolveDiskName(sort);
        if (sortAttr == null) {
            throw new BadRequestException("Unknown sort field: " + sort);
        }

        String path = params.getString("path", "");
        if (!path.isEmpty()) {
            path = ChemodanUtils.decodeFolderId(path);
        }

        this.path = path;

        this.collector =
            new AsyncChemodanCollector(sortAttr, !desc, offset + length);
    }

    public Long prefix() {
        return uid;
    }

    public int length() {
        return length;
    }

    public int offset() {
        return offset;
    }

    public int toFind() {
        return toFind;
    }

    public String path() {
        return path;
    }

    public String requestStr() {
        return requestStr;
    }

    public boolean tree() {
        return tree;
    }

    public boolean desc() {
        return desc;
    }

    @Override
    public Attr sortAttr() {
        return sortAttr;
    }

    public AsyncChemodanCollector collector() {
        return collector;
    }
}
