package ru.yandex.msearch.proxy.api.async.mail.chemodan;

import java.io.IOException;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;

import org.apache.http.HttpException;
import org.apache.http.concurrent.FutureCallback;
import ru.yandex.http.proxy.ProxyRequestHandler;
import ru.yandex.http.proxy.ProxySession;
import ru.yandex.http.util.AbstractFilterFutureCallback;
import ru.yandex.http.util.BadRequestException;
import ru.yandex.msearch.proxy.AsyncHttpServer;
import ru.yandex.parser.config.ConfigException;

public class ChemodanSearchHandler
    extends AbstractChemodanHandler
    implements ProxyRequestHandler
{
    public ChemodanSearchHandler(
        final AsyncHttpServer server)
        throws ConfigException
    {
        super(server);
    }

    @Override
    public void handle(
        final ProxySession session)
        throws HttpException, IOException
    {
        session.logger().info("Handling async");
        ChemodanSearchContext context = new ChemodanSearchContext(server, session);
        ChemodanPrinter printer = new ChemodanPrinter(context);
        foldersFetcher.fetch(context, new FoldersCallback(printer, context));
    }

    public static void collectFolders(
        final ChemodanSearchContext context,
        final String path,
        final Collection<String> fids,
        final boolean withFilesOnly)
    {
        ChemodanFolders folders = context.folders();
        AsyncChemodanCollector collector = context.collector();

        for (String fid: fids) {
            FolderChemodanDocument doc = folders.foldersFidMap().get(fid);
            if (doc == null) {
                continue;
            }
            if (withFilesOnly && doc.fileCount() <= 0) {
                continue;
            }
            doc.attr("id", ChemodanUtils.encodeFolderId(doc.id()));

            if (path == null) {
                collector.collect(doc);
            } else if (fid.equals(path)) {
                collector.setCurrentFolder(doc);
            } else {
                if (doc.parentId() != null
                    && !doc.parentId().equals(path))
                {
                    continue;
                }

                collector.collect(doc);
            }
        }
    }

    private static String makeFilesRequest(String request) {
        if (request == null || request.isEmpty()) {
            request = "attachname:*";
        } else if (request.contains("attachname:*")) {
            int or = request.indexOf(" OR ");
            if (or == -1) {
                request = request.toLowerCase(Locale.ENGLISH).replace('ё', 'е');
            } else {
                request = request.substring(
                    0,
                    or).toLowerCase(Locale.ENGLISH).replace('ё', 'е')
                    + " OR "
                    + request.substring(
                    or + 4).toLowerCase(Locale.ENGLISH).replace('ё', 'е');
            }
        } else {
            request = request
                .replaceAll("[*\\\\(){}\\[\\]'?~\u00a0+:!^\"-]", " ")
                .trim();
            String asteriskRequest =
                "*"
                    + request
                    .replaceAll(" +", "*")
                    .toLowerCase(Locale.ENGLISH)
                    .replace('ё', 'е')
                    + '*';
            String andedRequest = "(" + request.replaceAll(" +", " AND ") + ')';
            request = "attachname:" + andedRequest
                + " OR attachname:" + asteriskRequest
                + " OR attachname_keyword:" + asteriskRequest
                + " OR (attachname:* AND body_text,album,artist,author,"
                + "comment,composer,description,genre,keywords,subject,title,"
                + "attachtype:"
                + andedRequest + ')';
        }
        return applyFilter(request);
    }

    private class FoldersCallback
        extends AbstractFilterFutureCallback<ChemodanFolders, AsyncChemodanCollector>
    {
        private final ChemodanSearchContext context;

        public FoldersCallback(
            final FutureCallback<? super AsyncChemodanCollector> callback,
            final ChemodanSearchContext context)
        {
            super(callback);
            this.context = context;
        }

        @Override
        public void completed(final ChemodanFolders folders) {
            context.folders(folders);

            if ("foldername:*".equalsIgnoreCase(context.requestStr())) {
                //FIXME: this is an ugly hack
                List<String> filterFids = new LinkedList<String>();
                if (context.path().isEmpty()) {
                    filterFids.addAll(folders.foldersFidMap().keySet());
                } else {
                    ChemodanUtils.collectFilterFids(
                        folders,
                        context.path(),
                        9999,
                        filterFids);

                    filterFids.add(context.path());
                }

                collectFolders(context, null, filterFids, false);
                callback.completed(context.collector());
                return;
            }

            AsyncChemodanCollector collector = context.collector();

            int depth = Integer.MAX_VALUE;

            if (context.tree()) {
                depth = 0;
            }

            List<String> filterFids = new LinkedList<String>();
            boolean search = true;
            if (context.requestStr().isEmpty()) {
                search = false;
            }

            ChemodanUtils.collectFilterFids(folders, context.path(), depth, filterFids);

            if (!context.path().isEmpty()) {
                filterFids.add(context.path());
            }

            context.logger().fine("FilterFids: " + filterFids.toString());

            boolean launched = false;
            try {
                if (!context.tree()) {
                    search = true;
                }

                ChemodanSearchCallback searchCallback =
                    new ChemodanSearchCallback(
                        context,
                        filterFids,
                        search,
                        context.path(),
                        callback);

                if (!context.path().isEmpty()) {
                    collectFiles(
                        context,
                        makeFilesRequest(context.requestStr()),
                        filterFids,
                        searchCallback); //do not collect file for root list
                    launched = true;
                } else {
                    if (!context.tree() || !context.requestStr().isEmpty()) {
                        collectFiles(
                            context,
                            makeFilesRequest(context.requestStr()),
                            filterFids,
                            searchCallback); //do not collect file for root list
                        launched = true;
                    }
                }

                if (!launched) {
                    context.logger().info("Search not launched");
                    searchCallback.completed(
                        new ChemodanSearcherDocuments(0));
                }
            } catch (BadRequestException bre) {
                failed(bre);
                return;
            }
        }
    }
}
