package ru.yandex.msearch.proxy.api.async.mail.chemodan;

import java.util.ArrayList;
import java.util.List;

import ru.yandex.msearch.proxy.api.async.mail.documents.Document;

public class ChemodanSearcherDocuments {
    private List<Document> docs;
    private long total;

    public ChemodanSearcherDocuments(final int size) {
        this.docs = new ArrayList<>(size);
    }

    public List<Document> docs() {
        return docs;
    }

    public ChemodanSearcherDocuments docs(final List<Document> docs) {
        this.docs = docs;
        return this;
    }

    public long total() {
        return total;
    }

    public ChemodanSearcherDocuments total(final long total) {
        this.total = total;
        return this;
    }

    public int size() {
        return docs.size();
    }

    public void total(final int total) {
        this.total = total;
    }

    public void add(final String groupId, final Document doc) {
        this.docs.add(doc);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (Document doc: docs()) {
            sb.append(
                "lucene: attrs: "
                    + doc.doc().attrs()
                    + " merged: "
                    + doc.doc().mergedDocs());
            sb.append("\n");
        }
        return "ChemodanSearcherDocuments{" +
            "docs=" + sb.toString() +
            ", total=" + total +
            '}';
    }
}
