package ru.yandex.msearch.proxy.api.async.mail.chemodan;

import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;

import ru.yandex.http.util.BadRequestException;

public class ChemodanUtils {
    private static final Pattern NORMALIZE =
        Pattern.compile("(^[/\\\\]+|[/\\\\]+$)");

    public static String encodeFolderId(final String fid) {
        return "folder:" + fid;
    }

    private static String decodeId(final String path, final String type)
        throws BadRequestException
    {
        String normalized = normalizePath(path);
        if (!hasPrefix(normalized, type)) {
            throw new BadRequestException(
                "Invalid " + type + " id: '" + path
                    + "'. Expected format is 'file:\\d+' or 'folder:\\d+'");
        }
        return normalized.substring(type.length() + 1);
    }

    public static String decodeFolderId(final String fid)
        throws BadRequestException
    {
        return decodeId(fid, "folder");
    }

    public static String encodeFileId(final String fid) {
        return "file:" + fid;
    }

    public static String decodeFileId(final String fid)
        throws BadRequestException
    {
        return decodeId(fid, "file");
    }

    public static String normalizePath(final String path) {
        return NORMALIZE.matcher(path.trim()).replaceAll("");
    }

    private static boolean hasPrefix(final String path, final String prefix) {
        int length = prefix.length();
        if (path.length() > length + 1) {
            char c = path.charAt(length);
            return c == ':' && path.startsWith(prefix);
        }
        return false;
    }

    public static boolean isFolderPath(final String path) {
        return hasPrefix(normalizePath(path), "folder");
    }

    public static void collectFilterFids(
        final ChemodanFolders folders,
        final String path,
        final int depth,
        final List<String> fids)
    {
        if (depth < 0) {
            return;
        }
        List<FolderChemodanDocument> list =
            folders.foldersParentMap().get(path);
        if (list == null) {
            return;
        }
        Iterator<FolderChemodanDocument> iter = list.iterator();
        while (iter.hasNext()) {
            FolderChemodanDocument folder = iter.next();
            fids.add(folder.id());
            collectFilterFids(folders, folder.id(), depth - 1, fids);
        }
    }
}
