package ru.yandex.msearch.proxy.api.async.mail.chemodan;

public class FolderChemodanDocument extends AbstractChemodanDocument {
    private boolean system = false;
    private int fileCount = 0;

    public FolderChemodanDocument() {
        super(true);
    }

    public void incFileCount() {
        fileCount += 1;
    }

    public void incFileCount(final int count) {
        fileCount += count;
    }

    public int fileCount() {
        return fileCount;
    }

    public boolean system() {
        return system;
    }

    public FolderChemodanDocument system(final boolean system) {
        this.system = system;
        return this;
    }

    @Override
    public int compareTo(final AbstractChemodanDocument other) {
        if (other instanceof FolderChemodanDocument) {
            FolderChemodanDocument of = (FolderChemodanDocument) other;
            if (of.system() && !this.system()) {
                return 1;
            } else if (!of.system() && this.system()) {
                return -1;
            }
        }

        return super.compareTo(other);
    }
}
