package ru.yandex.msearch.proxy.api.async.mail.chemodan;

import java.util.List;

import ru.yandex.http.util.BadRequestException;
import ru.yandex.parser.uri.QueryConstructor;

public class SearcherContext {
    private final String request;
    private final int length;
    private final int offset;
    private final String sortAttr;
    private final List<String> filterFids;
    private final boolean desc;
    private final String searchBackendQuery;
    private final String filterSearchQuery;
    private final ChemodanContext context;

    public SearcherContext(
        final ChemodanContext context,
        final String request,
        final int length,
        final int offset,
        final String groupField,
        final String sortField,
        final List<String> filterFids,
        final boolean desc)
        throws BadRequestException
    {
        this.context = context;
        this.request = request;
        this.length = length;
        this.offset = offset;
        this.sortAttr = sortField;
        this.filterFids = filterFids;
        this.desc = desc;

        QueryConstructor luceneQuery = new QueryConstructor("/search-chemodan?");
        luceneQuery.append("prefix", context.user().prefix().toStringFast());
        luceneQuery.append("service", context.user().service());
        luceneQuery.append(
            "get",
            "mid,hid,received_date,attachname,attachsize_b,mimetype,url,"
                + sortField);
        if (groupField != null) {
            luceneQuery.append("group", "mid");
            luceneQuery.append("merge_func", "values");
        }

        luceneQuery.append("outer", "url");
        if (!desc) {
            luceneQuery.append("asc", "true");
        }
        luceneQuery.append("text", request);
        luceneQuery.append("sort", sortField);

        QueryConstructor fsQuery;
        if (context.corp()) {
            fsQuery = new QueryConstructor(
                context.server().config().corpFilterSearchConfig().uri().toString()
                    + '?');
        } else {
            fsQuery = new QueryConstructor(
                context.server().config().filterSearchConfig().uri().toString()
                    + '?');
        }

        fsQuery.append("uid", context.uid());
        fsQuery.append("mdb", "pg");

        for (String fid: filterFids) {
            fsQuery.append("fids", fid);
        }

        if (context.excludeSpam()) {
            fsQuery.append("excl_folders", "spam");
        }

        if (context.excludeTrash()) {
            fsQuery.append("excl_folders", "trash");
        }

        fsQuery.append("order", "default");

        this.searchBackendQuery = luceneQuery.toString();
        this.filterSearchQuery = fsQuery.toString();
    }

    public String request() {
        return request;
    }

    public int length() {
        return length;
    }

    public int offset() {
        return offset;
    }

    public String sortAttr() {
        return sortAttr;
    }

    public List<String> filterFids() {
        return filterFids;
    }

    public boolean desc() {
        return desc;
    }

    public String searchBackendQuery() {
        return searchBackendQuery;
    }

    public String filterSearchQuery() {
        return filterSearchQuery;
    }

    public ChemodanContext context() {
        return context;
    }
}
