package ru.yandex.msearch.proxy.api.async.mail.classification;

import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;

import ru.yandex.parser.string.NonNegativeIntegerValidator;

public class ClassificationConfigBuilder implements ClassificationConfig {
    private int timeout;
    private int toleratePositions;

    public ClassificationConfigBuilder() {
        this(ClassificationConfigDefaults.INSTANCE);
    }

    public ClassificationConfigBuilder(final ClassificationConfig config) {
        this.timeout(config.timeout());
        this.toleratePositions(config.toleratePositions());
    }

    public ClassificationConfigBuilder(
        final IniConfig config)
        throws ConfigException
    {
        this(config, ClassificationConfigDefaults.INSTANCE);
    }

    public ClassificationConfigBuilder(
        final IniConfig config,
        final ClassificationConfig defaults)
        throws ConfigException
    {
        timeout = config.getIntegerDuration(
            "timeout",
            defaults.timeout());
        toleratePositions = config.get(
            "tolerate-positions",
            NonNegativeIntegerValidator.INSTANCE);
    }

    @Override
    public int timeout() {
        return timeout;
    }

    public ClassificationConfigBuilder timeout(final int timeout) {
        this.timeout = timeout;
        return this;
    }

    @Override
    public int toleratePositions() {
        return toleratePositions;
    }

    public ClassificationConfigBuilder toleratePositions(
        final int toleratePositions)
    {
        this.toleratePositions = toleratePositions;
        return this;
    }
}
