package ru.yandex.msearch.proxy.api.async.mail.dialogue;

import java.io.IOException;
import java.util.Set;

import ru.yandex.json.writer.JsonValue;
import ru.yandex.json.writer.JsonWriterBase;
import ru.yandex.msearch.proxy.api.async.suggest.contact.ContactParser;
import ru.yandex.msearch.proxy.api.async.suggest.contact.ContactParser.Email;

public interface Dialogue extends JsonValue {
    long date();

    Set<Email> recipients();

    String subject();

    String firstline();

    int unreadCount();

    int size();

    String id();

    String type();

    String fid();

    String from();

    default void writeRecipients(final JsonWriterBase writer)
        throws IOException
    {
        writer.key("recipients");
        writer.startArray();
        for (ContactParser.Email email: recipients()) {
            writer.startObject();

            String[] parts = email.address().split("@");

            String domain;
            String local;
            if (parts.length > 1) {
                domain = parts[1];
                local = parts[0];
            } else {
                domain = email.address();
                local = email.address();
            }

            writer.key("domain");
            writer.value(domain);
            writer.key("local");
            writer.value(local);
            writer.key("displayName");
            writer.value(email.name());
            writer.endObject();
        }
        writer.endArray();
    }

    @Override
    default void writeValue(final JsonWriterBase writer) throws IOException {
        writeRecipients(writer);

        writer.key("dialogueType");
        writer.value(type());
        writer.key("dialogueId");
        writer.value(id());
        writer.key("subject");
        writer.value(subject());
        writer.key("firstline");
        writer.value(firstline());
        writer.key("receiveDate");
        writer.value(date());
        writer.key("unreadCount");
        writer.value(unreadCount());
        writer.key("fid");
        writer.value(fid());
        writer.key("from");
        writer.value(from());
    }
}
