package ru.yandex.msearch.proxy.api.async.mail.dialogue;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;

import ru.yandex.msearch.proxy.api.async.suggest.contact.ContactParser.Email;

public class DialogueBuilder implements Dialogue {
    private final String id;
    private final String type;

    private long date;
    private String subject;
    private String firstline;
    private int size;
    private Set<Email> recipients;
    private int unreadCount;
    private String mid;
    private String fid;
    private String from;

    public DialogueBuilder(final String id, final String type) {
        this.id = id;
        this.type = type;
        this.recipients = new LinkedHashSet<>();
    }

    @Override
    public String type() {
        return type;
    }

    @Override
    public long date() {
        return date;
    }

    public DialogueBuilder date(final long date) {
        this.date = date;
        return this;
    }

    @Override
    public String id() {
        return id;
    }

    @Override
    public String subject() {
        return subject;
    }

    public DialogueBuilder subject(final String subject) {
        this.subject = subject;
        return this;
    }

    @Override
    public String firstline() {
        return firstline;
    }

    public DialogueBuilder firstline(final String firstline) {
        this.firstline = firstline;
        return this;
    }

    @Override
    public int size() {
        return size;
    }

    public DialogueBuilder size(final int size) {
        this.size = size;
        return this;
    }

    @Override
    public Set<Email> recipients() {
        return recipients;
    }

    public DialogueBuilder recipients(final Set<Email> recipients) {
        this.recipients = recipients;
        return this;
    }

    public DialogueBuilder addRecipients(final Email recipient) {
        this.recipients.add(recipient);
        return this;
    }

    public DialogueBuilder addRecipients(final Collection<Email> recipients) {
        this.recipients.addAll(recipients);
        return this;
    }

    @Override
    public int unreadCount() {
        return unreadCount;
    }

    public DialogueBuilder unreadCount(final int unreadCount) {
        this.unreadCount = unreadCount;
        return this;
    }

    public String mid() {
        return mid;
    }

    public DialogueBuilder mid(final String mid) {
        this.mid = mid;
        return this;
    }

    public Dialogue build() {
        return new ImmutableDialogue(this);
    }

    public String fid() {
        return fid;
    }

    public DialogueBuilder fid(final String fid) {
        this.fid = fid;
        return this;
    }

    public String from() {
        return from;
    }

    public DialogueBuilder from(final String from) {
        this.from = from;
        return this;
    }
}
