package ru.yandex.msearch.proxy.api.async.mail.dialogue;

import java.io.IOException;

import java.util.HashMap;
import java.util.Map;

import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.HttpStatus;

import org.apache.http.client.methods.HttpGet;
import org.apache.http.concurrent.Cancellable;
import org.apache.http.nio.protocol.BasicAsyncRequestConsumer;
import org.apache.http.nio.protocol.HttpAsyncExchange;
import org.apache.http.nio.protocol.HttpAsyncRequestConsumer;
import org.apache.http.nio.protocol.HttpAsyncRequestHandler;

import org.apache.http.nio.protocol.HttpAsyncResponseProducer;
import org.apache.http.protocol.HttpContext;

import ru.yandex.http.proxy.BasicProxySession;
import ru.yandex.http.proxy.ProxySession;

import ru.yandex.msearch.proxy.AsyncHttpServer;
import ru.yandex.msearch.proxy.api.async.mail.MailSearchHandler;

public class DialogueThreadHandler
    implements HttpAsyncRequestHandler<HttpRequest>
{
    private final AsyncHttpServer server;
    private final MailSearchHandler searchHandler;
    private final String LUCENE_REQUEST = "&imap=1&request=hid:0+AND+thread_id:";

    public DialogueThreadHandler(final AsyncHttpServer server) {
        this.server = server;

        this.searchHandler = new MailSearchHandler(server, "dialogue-");
    }

    @Override
    public HttpAsyncRequestConsumer<HttpRequest> processRequest(
        final HttpRequest httpRequest,
        final HttpContext httpContext)
        throws HttpException, IOException
    {
        return new BasicAsyncRequestConsumer();
    }

    @Override
    public void handle(
        final HttpRequest request,
        final HttpAsyncExchange exchange,
        final HttpContext context)
        throws HttpException, IOException
    {
        ProxySession session = new BasicProxySession(server, exchange, context);

        Map<String, String> data = new HashMap<>();
        data.put("163818436445602704", "{\n" +
            "   \"attachments\":[\n" +
            "\n" +
            "   ],\n" +
            "   \"envelopes\":[\n" +
            "      {\n" +
            "         \"mid\":\"163818436445602704\",\n" +
            "         \"subject\":\"Подарок на ДР начальнику\",\n" +
            "         \"firstline\":\"Предлагаю подарить ключ от Bolgen OS\",\n" +
            "         \"labels\":[\n" +
            "            \"77\",\n" +
            "            \"79\",\n" +
            "            \"87\",\n" +
            "            \"92\",\n" +
            "            \"FAKE_ATTACHED_LBL\",\n" +
            "            \"FAKE_RECENT_LBL\"\n" +
            "         ],\n" +
            "         \"subjectInfo\":{\n" +
            "            \"prefix\":\"Re: \",\n" +
            "            \"isSplitted\":true,\n" +
            "            \"postfix\":\"\",\n" +
            "            \"subject\":\"Подарок на ДР начальнику\",\n" +
            "            \"type\":\"replied\"\n" +
            "         },\n" +
            "         \"threadId\":\"163818436445602704\",\n" +
            "         \"receiveDate\":1507790509,\n" +
            "         \"size\":60672,\n" +
            "         \"inReplyTo\":\"\",\n" +
            "         \"imapId\":\"70\",\n" +
            "         \"hdrStatus\":\"\",\n" +
            "         \"cc\":[\n" +
            "\n" +
            "         ],\n" +
            "         \"from\":[\n" +
            "            {\n" +
            "               \"domain\":\"yandex.ru\",\n" +
            "               \"local\":\"ivan.dudinov\",\n" +
            "               \"displayName\":\"Ivan Dudinov\"\n" +
            "            }\n" +
            "         ],\n" +
            "         \"replyTo\":[\n" +
            "            {\n" +
            "               \"domain\":\"yandex.ru\",\n" +
            "               \"local\":\"ivan.dudinov\",\n" +
            "               \"displayName\":\"ivan.dudinov@yandex.ru\"\n" +
            "            }\n" +
            "         ],\n" +
            "         \"to\":[\n" +
            "            {\n" +
            "               \"domain\":\"yandex.ru\",\n" +
            "               \"local\":\"mokrushin\",\n" +
            "               \"displayName\":\"Mikhail Mokrushin\"\n" +
            "            }\n" +
            "         ]\n" +
            "      },\n" +
            "      {\n" +
            "         \"mid\":\"163818436445602703\",\n" +
            "         \"subject\":\"Подарок на ДР начальнику\",\n" +
            "         \"firstline\":\"У кого какие предложения\",\n" +
            "         \"labels\":[\n" +
            "            \"77\",\n" +
            "            \"79\",\n" +
            "            \"87\",\n" +
            "            \"92\",\n" +
            "            \"FAKE_ATTACHED_LBL\",\n" +
            "            \"FAKE_RECENT_LBL\"\n" +
            "         ],\n" +
            "         \"subjectInfo\":{\n" +
            "            \"prefix\":\"\",\n" +
            "            \"isSplitted\":true,\n" +
            "            \"postfix\":\"\",\n" +
            "            \"subject\":\"Подарок на ДР начальнику\",\n" +
            "            \"type\":\"\"\n" +
            "         },\n" +
            "         \"threadId\":\"163818436445602704\",\n" +
            "         \"receiveDate\":1507790009,\n" +
            "         \"size\":60672,\n" +
            "         \"inReplyTo\":\"\",\n" +
            "         \"imapId\":\"70\",\n" +
            "         \"hdrStatus\":\"\",\n" +
            "         \"cc\":[\n" +
            "\n" +
            "         ],\n" +
            "         \"to\":[\n" +
            "            {\n" +
            "               \"domain\":\"yandex.ru\",\n" +
            "               \"local\":\"ivan.dudinov\",\n" +
            "               \"displayName\":\"Ivan Dudinov\"\n" +
            "            }\n" +
            "         ],\n" +
            "         \"from\":[\n" +
            "            {\n" +
            "               \"domain\":\"yandex.ru\",\n" +
            "               \"local\":\"ivan.dudinov\",\n" +
            "               \"displayName\":\"ivan.dudinov@yandex.ru\"\n" +
            "            }\n" +
            "         ]\n" +
            "      }\n" +
            "   ]\n" +
            "}");

        data.put("200500", "{\n" +
            "   \"attachments\":[\n" +
            "\n" +
            "   ],\n" +
            "   \"envelopes\":[\n" +
            "      {\n" +
            "         \"mid\":\"153818436445602704\",\n" +
            "         \"subject\":\"Захват мира\",\n" +
            "         \"firstline\":\"Список покупок для захвата мира\",\n" +
            "         \"labels\":[\n" +
            "            \"77\",\n" +
            "            \"79\",\n" +
            "            \"87\",\n" +
            "            \"92\",\n" +
            "            \"FAKE_ATTACHED_LBL\",\n" +
            "            \"FAKE_RECENT_LBL\"\n" +
            "         ],\n" +
            "         \"subjectInfo\":{\n" +
            "            \"prefix\":\"Re: \",\n" +
            "            \"isSplitted\":true,\n" +
            "            \"postfix\":\"\",\n" +
            "            \"subject\":\"Захват мира\",\n" +
            "            \"type\":\"replied\"\n" +
            "         },\n" +
            "         \"threadId\":\"200500\",\n" +
            "         \"receiveDate\":1507792509,\n" +
            "         \"size\":60672,\n" +
            "         \"inReplyTo\":\"\",\n" +
            "         \"imapId\":\"70\",\n" +
            "         \"hdrStatus\":\"\",\n" +
            "         \"cc\":[\n" +
            "\n" +
            "         ],\n" +
            "         \"from\":[\n" +
            "            {\n" +
            "               \"domain\":\"yandex.ru\",\n" +
            "               \"local\":\"durak\",\n" +
            "               \"displayName\":\"Иван Дурак\"\n" +
            "            }\n" +
            "         ],\n" +
            "         \"replyTo\":[\n" +
            "            {\n" +
            "               \"domain\":\"yandex.ru\",\n" +
            "               \"local\":\"durak\",\n" +
            "               \"displayName\":\"Иван Дурак\"\n" +
            "            }\n" +
            "         ],\n" +
            "         \"to\":[\n" +
            "            {\n" +
            "               \"domain\":\"yandex.ru\",\n" +
            "               \"local\":\"kashei.immortal\",\n" +
            "               \"displayName\":\"Кащей Бессмертный\"\n" +
            "            }\n" +
            "         ]\n" +
            "      },\n" +
            "      {\n" +
            "         \"mid\":\"143818436445602703\",\n" +
            "         \"subject\":\"Захват мира\",\n" +
            "         \"firstline\":\"Что еще нужно\",\n" +
            "         \"labels\":[\n" +
            "            \"77\",\n" +
            "            \"79\",\n" +
            "            \"87\",\n" +
            "            \"92\",\n" +
            "            \"FAKE_ATTACHED_LBL\",\n" +
            "            \"FAKE_RECENT_LBL\"\n" +
            "         ],\n" +
            "         \"subjectInfo\":{\n" +
            "            \"prefix\":\"\",\n" +
            "            \"isSplitted\":true,\n" +
            "            \"postfix\":\"\",\n" +
            "            \"subject\":\"\",\n" +
            "            \"type\":\"\"\n" +
            "         },\n" +
            "         \"threadId\":\"200500\",\n" +
            "         \"receiveDate\":1507792508,\n" +
            "         \"size\":60672,\n" +
            "         \"inReplyTo\":\"\",\n" +
            "         \"imapId\":\"70\",\n" +
            "         \"hdrStatus\":\"\",\n" +
            "         \"cc\":[\n" +
            "\n" +
            "         ],\n" +
            "         \"to\":[\n" +
            "            {\n" +
            "               \"domain\":\"yandex.ru\",\n" +
            "               \"local\":\"durak\",\n" +
            "               \"displayName\":\"Иван Дурак\"\n" +
            "            }\n" +
            "         ],\n" +
            "         \"from\":[\n" +
            "            {\n" +
            "               \"domain\":\"yandex.ru\",\n" +
            "               \"local\":\"kashei.immortal\",\n" +
            "               \"displayName\":\"Кащей Бессмертный\"\n" +
            "            }\n" +
            "         ]\n" +
            "      }\n" +
            "   ]\n" +
            "}");

        String threadId = session.params().getString("threadId");
        if (!session.params().getBoolean("nostatic", false)) {
            session.response(HttpStatus.SC_OK, data.get(threadId));
            return;
        }

        HttpGet get =
            new HttpGet(request.getRequestLine().getUri() + LUCENE_REQUEST + threadId);
        searchHandler.handle(
            get,
            new ProxyHttpExchange(exchange, get),
            context);
    }

    private final class ProxyHttpExchange implements HttpAsyncExchange {
        private final HttpAsyncExchange wrapped;
        private final HttpRequest request;

        public ProxyHttpExchange(
            final HttpAsyncExchange wrapped,
            final HttpRequest request)
        {
            this.wrapped = wrapped;
            this.request = request;
        }

        @Override
        public HttpRequest getRequest() {
            return request;
        }

        @Override
        public HttpResponse getResponse() {
            return wrapped.getResponse();
        }

        @Override
        public void submitResponse() {
            wrapped.submitResponse();
        }

        @Override
        public void submitResponse(
            final HttpAsyncResponseProducer httpAsyncResponseProducer)
        {
            wrapped.submitResponse();
        }

        @Override
        public boolean isCompleted() {
            return wrapped.isCompleted();
        }

        @Override
        public void setCallback(final Cancellable cancellable) {
            wrapped.setCallback(cancellable);
        }

        @Override
        public void setTimeout(final int i) {
            wrapped.setTimeout(i);
        }

        @Override
        public int getTimeout() {
            return wrapped.getTimeout();
        }
    }
}