package ru.yandex.msearch.proxy.api.async.mail.dialogue;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

import org.apache.http.concurrent.FutureCallback;
import ru.yandex.http.util.AbstractFilterFutureCallback;
import ru.yandex.json.dom.JsonList;
import ru.yandex.json.dom.JsonMap;
import ru.yandex.json.dom.JsonObject;
import ru.yandex.json.parser.JsonException;

public class DialoguesFilterSearchCallback
    extends AbstractFilterFutureCallback<JsonObject, List<Dialogue>>
{
    private final Map<String, DialogueBuilder> midMap;

    public DialoguesFilterSearchCallback(
        final Map<String, DialogueBuilder> dbs,
        final FutureCallback<? super List<Dialogue>> callback)
    {
        super(callback);

        midMap = new LinkedHashMap<>(dbs.size());
        for (Map.Entry<String, DialogueBuilder> entry: dbs.entrySet()) {
            midMap.put(entry.getValue().mid(), entry.getValue());
        }
    }

    @Override
    public void completed(final JsonObject root) {
        try {
            JsonList envelopes = root.get("envelopes").asList();
            for (int i = 0; i < envelopes.size(); ++i) {
                JsonMap envelope = envelopes.get(i).asMap();
                String mid = envelope.getString("mid");
                DialogueBuilder builder = midMap.get(mid);
                builder.subject(
                    envelope.get("subjectInfo").asMap()
                        .get("subject").asString());
                builder.firstline(envelope.get("firstline").asString());
            }
        } catch (JsonException je) {
            failed(je);
            return;
        }

        callback.completed(new ArrayList<>(midMap.values()));
    }
}