package ru.yandex.msearch.proxy.api.async.mail.dialogue;

import java.io.IOException;
import java.io.OutputStreamWriter;
import java.nio.charset.CodingErrorAction;
import java.util.List;

import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.HttpStatus;

import org.apache.http.entity.ContentType;

import org.apache.http.nio.entity.NByteArrayEntity;

import org.apache.http.nio.protocol.BasicAsyncRequestConsumer;
import org.apache.http.nio.protocol.HttpAsyncExchange;
import org.apache.http.nio.protocol.HttpAsyncRequestConsumer;
import org.apache.http.nio.protocol.HttpAsyncRequestHandler;

import org.apache.http.protocol.HttpContext;

import ru.yandex.http.proxy.AbstractProxySessionCallback;
import ru.yandex.http.proxy.BasicProxySession;
import ru.yandex.http.proxy.ProxySession;

import ru.yandex.http.util.BadRequestException;

import ru.yandex.http.util.nio.BasicAsyncRequestProducerGenerator;
import ru.yandex.http.util.nio.NByteArrayEntityFactory;

import ru.yandex.io.DecodableByteArrayOutputStream;

import ru.yandex.json.writer.JsonWriter;

import ru.yandex.msearch.proxy.AsyncHttpServer;

import ru.yandex.msearch.proxy.api.async.ProxyParams;
import ru.yandex.msearch.proxy.api.async.mail.searcher.ProducerParallelSearcher;

import ru.yandex.parser.searchmap.User;

import ru.yandex.parser.uri.CgiParams;

import ru.yandex.search.prefix.Prefix;
import ru.yandex.search.prefix.PrefixType;

public class DialoguesHandler implements HttpAsyncRequestHandler<HttpRequest> {
    private final AsyncHttpServer server;
    private final String LUCENE_REQUEST =
        "&get=mid,thread_id,fid,hdr_from,hdr_to,hdr_cc,unread,received_date"
            + "&group=thread_id&sort=received_date"
            + "&text=hid:0+AND+NOT+folder_type:(trash+spam)"
            + "+AND+message_type:people";

    public DialoguesHandler(final AsyncHttpServer server) {
        this.server = server;
    }

    @Override
    public HttpAsyncRequestConsumer<HttpRequest> processRequest(
        final HttpRequest httpRequest,
        final HttpContext httpContext)
        throws HttpException, IOException
    {
        return new BasicAsyncRequestConsumer();
    }

    public static User createUser(
        final AsyncHttpServer server,
        final ProxySession session)
        throws BadRequestException
    {
        CgiParams params = session.params();
        String mdb = params.getString(ProxyParams.MDB);
        PrefixType prefixType = server.searchMap().prefixType(mdb);
        Prefix suid;
        Prefix uid;
        Prefix prefix;
        String userIdField;
        if (mdb.equals(ProxyParams.PG)) {
            suid = params.get(ProxyParams.SUID, null, prefixType);
            uid = params.get(ProxyParams.UID, prefixType);
            prefix = uid;
            userIdField = ProxyParams.UID;
        } else {
            suid = params.get(ProxyParams.SUID, prefixType);
            uid = params.get(ProxyParams.UID, null, prefixType);
            prefix = suid;
            userIdField = ProxyParams.SUID;
        }

        return new User(server.resolveService(mdb, prefix), prefix);
    }

    @Override
    public void handle(
        final HttpRequest request,
        final HttpAsyncExchange exchange,
        final HttpContext context)
        throws HttpException, IOException
    {
        ProxySession session =
            new BasicProxySession(server, exchange, context);

        if (!session.params().getBoolean("nostatic", false)) {
            session.response(
                HttpStatus.SC_OK,
                "[{\n" +
                    "  \"unreadCount\": 0,\n" +
                    "  \"receiveDate\": 1507795509,\n" +
                    "  \"firstline\": \"Первая строчка диалога\",\n" +
                    "  \"subject\": \"Как дела?\",\n" +
                    "  \"dialogId\": \"ivan.dudinov@yandex.ru\",\n" +
                    "  \"dialogType\": \"tetatet\",\n" +
                    "  \"recipients\": [\n" +
                    "    {\n" +
                    "      \"displayName\": \"Ivan Dudinov\",\n" +
                    "      \"local\": \"ivan.dudinov\",\n" +
                    "      \"domain\": \"yandex.ru\"\n" +
                    "    }\n" +
                    "  ]\n" +
                    "},\n" +
                    "{\n" +
                    "  \"unreadCount\": 0,\n" +
                    "  \"receiveDate\": 1507792509,\n" +
                    "  \"firstline\": \"Список покупок для захвата мира\",\n" +
                    "  \"subject\": \"Захват мира\",\n" +
                    "  \"dialogId\": \"kashei.immortal@evil.com\",\n" +
                    "  \"dialogType\": \"tetatet\",\n" +
                    "  \"recipients\": [\n" +
                    "    {\n" +
                    "      \"displayName\": \"Кащей Бессмертный\",\n" +
                    "      \"local\": \"kashei.immortal\",\n" +
                    "      \"domain\": \"evil.com\"\n" +
                    "    }\n" +
                    "  ]\n" +
                    "},\n" +
                    "{\n" +
                    "  \"unreadCount\": 5,\n" +
                    "  \"receiveDate\": 1507790509,\n" +
                    "  \"firstline\": \"Предлагаю подарить ключ от Bolgen OS\",\n" +
                    "  \"subject\": \"Подарок на ДР начальнику\",\n" +
                    "  \"dialogType\": \"thread\",\n" +
                    "  \"dialogId\": \"thread:163818436445602704\",\n" +
                    "  \"recipients\": [\n" +
                    "    {\n" +
                    "      \"displayName\": \"Ilya Vorobiev\",\n" +
                    "      \"local\": \"vorobei\",\n" +
                    "      \"domain\": \"yandex.ru\"\n" +
                    "    },\n" +
                    "    {\n" +
                    "      \"displayName\": \"Mikhail Mokrushin\",\n" +
                    "      \"local\": \"mokrushin\",\n" +
                    "      \"domain\": \"yandex.ru\"\n" +
                    "    },\n" +
                    "    {\n" +
                    "      \"displayName\": \"Ivan Dudinov\",\n" +
                    "      \"local\": \"ivan.dudinov\",\n" +
                    "      \"domain\": \"yandex.ru\"\n" +
                    "    }\n" +
                    "  ]\n" +
                    "}]");
            return;
        }

        User user = createUser(server, session);
        ProducerParallelSearcher searcher = new ProducerParallelSearcher(
            server, session, user);

        DialoguesRequestInfo requestInfo = new DialoguesRequestInfo(session);

        StringBuilder sb = new StringBuilder("/search?prefix=");
        sb.append(user.prefix());
        sb.append("&service=");
        sb.append(user.service());
        sb.append("&length=");
        sb.append(requestInfo.totalLength() * 20);
        sb.append(LUCENE_REQUEST);

        searcher.search(
            new BasicAsyncRequestProducerGenerator(sb.toString()),
            new DialoguesSearchCallback(
                server,
                session,
                requestInfo,
                new DialoguesCallback(session, requestInfo)));
    }

    private static final class DialoguesCallback
        extends AbstractProxySessionCallback<List<Dialogue>>
    {
        protected final DialoguesRequestInfo requestInfo;

        public DialoguesCallback(
            final ProxySession session,
            final DialoguesRequestInfo requestInfo)
        {
            super(session);

            this.requestInfo = requestInfo;
        }

        @Override
        public void completed(final List<Dialogue> dialogues) {
            DecodableByteArrayOutputStream out =
                new DecodableByteArrayOutputStream();
            try (OutputStreamWriter outWriter =
                     new OutputStreamWriter(
                         out,
                         session.acceptedCharset().newEncoder()
                             .onMalformedInput(CodingErrorAction.REPLACE)
                             .onUnmappableCharacter(CodingErrorAction.REPLACE));
                 JsonWriter writer = requestInfo.jsonType().create(outWriter))
            {
                writer.startArray();

                int index = 0;

                for (Dialogue dialogue: dialogues) {
                    index += 1;
                    if (index < requestInfo.offset()) {
                        continue;
                    } else if (index > requestInfo.totalLength()) {
                        break;
                    }

                    writer.startObject();
                    writer.value(dialogue);
                    writer.endObject();
                }

                writer.endArray();
            } catch (IOException ioe) {
                failed(ioe);
                return;
            }

            NByteArrayEntity entity =
                out.processWith(NByteArrayEntityFactory.INSTANCE);
            entity.setContentType(
                ContentType.APPLICATION_JSON.withCharset(
                    session.acceptedCharset())
                    .toString());
            session.response(HttpStatus.SC_OK, entity);
        }

        public ProxySession session() {
            return session;
        }
    }
}
