package ru.yandex.msearch.proxy.api.async.mail.dialogue;

import ru.yandex.http.proxy.ProxySession;

import ru.yandex.http.util.BadRequestException;

import ru.yandex.json.writer.JsonType;
import ru.yandex.json.writer.JsonTypeExtractor;
import ru.yandex.msearch.proxy.api.async.mail.RequestInfo;

import ru.yandex.parser.string.NonNegativeIntegerValidator;

public class DialoguesRequestInfo {
    private final int offset;
    private final int length;
    private final String selfEmail;
    private final JsonType jsonType;

    public DialoguesRequestInfo(
        final ProxySession session)
        throws BadRequestException
    {
        offset = session.params().get(
            RequestInfo.FIRST,
            0,
            NonNegativeIntegerValidator.INSTANCE);
        length = session.params().get(
            RequestInfo.COUNT,
            10,
            NonNegativeIntegerValidator.INSTANCE);

        selfEmail =
            session.params().getString("login").trim() + "@yandex.ru";

        jsonType = JsonTypeExtractor.NORMAL.extract(session.params());
    }

    public int offset() {
        return offset;
    }

    public int length() {
        return length;
    }

    public String selfEmail() {
        return selfEmail;
    }

    public int totalLength() {
        return offset + length;
    }

    public JsonType jsonType() {
        return jsonType;
    }
}
