package ru.yandex.msearch.proxy.api.async.mail.dialogue;

import java.util.LinkedHashSet;
import java.util.Set;

import ru.yandex.msearch.proxy.api.async.suggest.contact.ContactParser.Email;

public class ImmutableDialogue implements Dialogue {
    private final long date;
    private final String id;
    private final String type;

    private final String subject;
    private final String firstline;
    private final int size;
    private final Set<Email> recipients;
    private final int unreadCount;
    private final String fid;
    private final String from;

    public ImmutableDialogue(final Dialogue dialogue) {
        this.id = dialogue.id();
        this.type = dialogue.type();

        this.date = dialogue.date();
        this.firstline = dialogue.firstline();
        this.subject = dialogue.subject();
        this.size = dialogue.size();
        this.recipients = new LinkedHashSet<>(dialogue.recipients());
        this.unreadCount = dialogue.unreadCount();
        this.fid = fid();
        this.from = from();
    }

    @Override
    public long date() {
        return date;
    }

    @Override
    public String id() {
        return id;
    }

    @Override
    public String type() {
        return type;
    }

    @Override
    public String subject() {
        return subject;
    }

    @Override
    public String firstline() {
        return firstline;
    }

    @Override
    public int size() {
        return size;
    }

    @Override
    public Set<Email> recipients() {
        return recipients;
    }

    @Override
    public int unreadCount() {
        return unreadCount;
    }

    @Override
    public String fid() {
        return fid;
    }

    @Override
    public String from() {
        return from;
    }
}
