package ru.yandex.msearch.proxy.api.async.mail.direct;

import org.apache.http.HttpException;
import ru.yandex.msearch.proxy.api.async.mail.SearchSession;

import ru.yandex.msearch.proxy.api.async.mail.relevance.search.MailSearchRelevanceFactory;
import ru.yandex.msearch.proxy.api.async.mail.relevance.search.MailSearchSorterFactory;
import ru.yandex.msearch.proxy.api.async.mail.relevance.search.RankingSession;

import ru.yandex.msearch.proxy.api.async.mail.rules.SearchRule;

public class DirectRelevanceRule implements SearchRule {
    private final SearchRule next;
    private final MailSearchRelevanceFactory relevanceFactory;

    public DirectRelevanceRule(
        final SearchRule next,
        final MailSearchRelevanceFactory relevanceFactory)
    {
        this.next = next;
        this.relevanceFactory = relevanceFactory;
    }

    @Override
    public void execute(final SearchSession session) throws HttpException {
        if (!session.params().getBoolean("ranking", false)) {
            this.next.execute(session);
            return;
        }

        MailSearchSorterFactory sorterFactory =
            relevanceFactory.create(
                session,
                session.requestInfo().options().userSplit());
        if (sorterFactory == null) {
            session.httpSession().logger().info(
                "No model for request, skipping");
            this.next.execute(session);
            return;
        } else {
            session.httpSession().logger().info(
                "User model " + sorterFactory.name());
        }

        RankingSession rankingSession =
            new RankingSession(session, sorterFactory.build(session));

        this.next.execute(session.withCallback(rankingSession));
    }
}