package ru.yandex.msearch.proxy.api.async.mail.direct;

import java.io.IOException;

import org.apache.http.HttpException;
import org.apache.http.HttpRequest;

import org.apache.http.nio.protocol.BasicAsyncRequestConsumer;
import org.apache.http.nio.protocol.HttpAsyncExchange;
import org.apache.http.nio.protocol.HttpAsyncRequestConsumer;
import org.apache.http.nio.protocol.HttpAsyncRequestHandler;

import org.apache.http.protocol.HttpContext;

import ru.yandex.function.GenericFunction;

import ru.yandex.http.util.BadRequestException;

import ru.yandex.msearch.proxy.AsyncHttpServer;

import ru.yandex.msearch.proxy.api.async.BasicSession;
import ru.yandex.msearch.proxy.api.async.Session;

import ru.yandex.msearch.proxy.api.async.mail.BasicSearchSession;
import ru.yandex.msearch.proxy.api.async.mail.DefaultSearchAttributes;
import ru.yandex.msearch.proxy.api.async.mail.MailSearchHandler
    .BasicDocumentsFactory;
import ru.yandex.msearch.proxy.api.async.mail.RequestInfo;
import ru.yandex.msearch.proxy.api.async.mail.SearchAttributes;

import ru.yandex.msearch.proxy.api.async.mail.relevance.DirectPersonalFactorsGatherRule;
import ru.yandex.msearch.proxy.api.async.mail.relevance.FuzzyRequestMidProcessorFactory;

import ru.yandex.msearch.proxy.api.async.mail.relevance.MtypeRequestProcessorFactory;
import ru.yandex.msearch.proxy.api.async.mail.relevance.search.MailSearchRelevanceFactory;

import ru.yandex.msearch.proxy.api.async.mail.rules.ResolveUidRule;
import ru.yandex.msearch.proxy.api.async.mail.rules.RewriteRequestRule;
import ru.yandex.msearch.proxy.api.async.mail.rules.RuleContext;
import ru.yandex.msearch.proxy.api.async.mail.rules.SearchRule;

import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.uri.CgiParams;

public class DirectSearchHandler
    implements HttpAsyncRequestHandler<HttpRequest>
{
    private final AsyncHttpServer server;
    private final SearchRule rule;

    public DirectSearchHandler(
        final AsyncHttpServer server)
        throws ConfigException
    {
        this.server = server;

        this.rule = createRule(server, server.relevance());
    }

    public static SearchRule createRule(final AsyncHttpServer server) {
        return createRule(server, server.relevance());
    }

    public static SearchRule createRule(
        final AsyncHttpServer server,
        final MailSearchRelevanceFactory relevanceFactory)
    {
        RuleContext ruleContext =
            new RuleContext(
                server,
                BasicDocumentsFactory.INSTANCE,
                DirectSearchAttributesFactory.INSTANCE);

        SearchRule next = new SimplePlainSearchRule(ruleContext);

        SearchRule rule = new RewriteRequestRule(server, next);
        rule = new DirectPersonalFactorsGatherRule(
            rule,
            server,
            FuzzyRequestMidProcessorFactory.INSTANCE,
            MtypeRequestProcessorFactory.INSTANCE);

        rule = new DirectRelevanceRule(rule, relevanceFactory);
        SearchRule resolveUidRule =
            new ResolveUidRule(rule, server);

        return new DirectSearchRule(resolveUidRule);
    }

    @Override
    public HttpAsyncRequestConsumer<HttpRequest> processRequest(
        final HttpRequest httpRequest,
        final HttpContext httpContext)
        throws HttpException, IOException
    {
        return new BasicAsyncRequestConsumer();
    }

    @Override
    public void handle(
        final HttpRequest request,
        final HttpAsyncExchange exchange,
        final HttpContext context)
        throws HttpException, IOException
    {
        Session httpSession = new BasicSession(server, exchange, context);
        CgiParams params = new CgiParams(request);
        RequestInfo requestInfo =
            new RequestInfo(httpSession, request, params);

        DirectPrinter printer = new DirectPrinter(requestInfo);
        rule.execute(new BasicSearchSession(requestInfo, params, printer));
    }

    private enum DirectSearchAttributesFactory
        implements GenericFunction<
        CgiParams,
        SearchAttributes,
        BadRequestException>
    {
        INSTANCE;

        @Override
        public SearchAttributes apply(final CgiParams params)
            throws BadRequestException
        {
            return new DirectSearchAttributes(params);
        }
    }

    private static class DirectSearchAttributes
        extends DefaultSearchAttributes
    {
        private final String get;
        private final String mergeFunc;

        public DirectSearchAttributes(
            final CgiParams params)
            throws BadRequestException
        {
            super(params);

            this.get = params.getString("get", "*");
            this.mergeFunc =
                params.getString("merge_func", super.luceneMergeFunc());
        }

        @Override
        public String luceneGet() {
            return get;
        }

        @Override
        public String luceneMergeFunc() {
            return mergeFunc;
        }
    }
}
