package ru.yandex.msearch.proxy.api.async.mail.direct;

import org.apache.http.HttpException;
import ru.yandex.msearch.proxy.api.async.mail.SearchSession;
import ru.yandex.msearch.proxy.api.async.mail.rules.SearchRule;
import ru.yandex.parser.uri.CgiParams;

public class DirectSearchRule implements SearchRule {
    private final SearchRule next;

    public DirectSearchRule(final SearchRule next) {
        this.next = next;
    }

    @Override
    public void execute(final SearchSession session) throws HttpException {
        SearchSession sessionCopy = session.copy();
        CgiParams params = sessionCopy.params();

        params.replace(
            "nolaf",
            String.valueOf(params.getBoolean("nolaf", true)));

        this.next.execute(sessionCopy);
    }
}
