package ru.yandex.msearch.proxy.api.async.mail.direct;

import java.util.Collections;
import java.util.Iterator;

import ru.yandex.io.StringBuilderWriter;
import ru.yandex.json.dom.JsonMap;
import ru.yandex.json.writer.JsonType;
import ru.yandex.msearch.proxy.api.async.mail.documents.Document;
import ru.yandex.msearch.proxy.api.async.mail.documents.DocumentsGroup;
import ru.yandex.search.result.SearchDocument;

public class LuceneDocument implements Document, DocumentsGroup {
    private final SearchDocument document;
    private final String id;

    public LuceneDocument(final SearchDocument document) {
        this.document = document;
        this.id = document.attrs().getOrDefault("url", null);
    }

    @Override
    public Iterator<Document> iterator() {
        return Collections.<Document>singletonList(this).iterator();
    }

    @Override
    public String id() {
        return this.id;
    }

    @Override
    public SearchDocument doc() {
        return document;
    }

    @Override
    public JsonMap envelope() {
        return JsonMap.EMPTY;
    }

    @Override
    public void add(final Document doc) {
        throw new UnsupportedOperationException("Unable add to LuceneDocument");
    }

    @Override
    public Document best() {
        return this;
    }

    @Override
    public int size() {
        return 1;
    }
}
